package physx.vehicle;

import physx.NativeObject;
import physx.common.PxVec3;

public class PxVehicleChassisData extends NativeObject {

    public static PxVehicleChassisData wrapPointer(long address) {
        return new PxVehicleChassisData(address);
    }
    
    protected PxVehicleChassisData(long address) {
        super(address);
    }

    // Constructors

    public PxVehicleChassisData() {
        address = _PxVehicleChassisData();
    }
    private static native long _PxVehicleChassisData();

    // Destructor

    public void destroy() {
        if (address == 0L) {
            throw new IllegalStateException(this + " is already deleted");
        }
        if (isExternallyAllocated) {
            throw new IllegalStateException(this + " is externally allocated and cannot be manually destroyed");
        }
        _delete_native_instance(address);
        address = 0L;
    }
    private static native long _delete_native_instance(long address);

    // Attributes

    /**
     * @return WebIDL type: {@link PxVec3} [Value]
     */
    public PxVec3 getMMOI() {
        return PxVec3.wrapPointer(_getMMOI(address));
    }
    private static native long _getMMOI(long address);

    /**
     * @param value WebIDL type: {@link PxVec3} [Value]
     */
    public void setMMOI(PxVec3 value) {
        _setMMOI(address, value.getAddress());
    }
    private static native void _setMMOI(long address, long value);

    /**
     * @return WebIDL type: float
     */
    public float getMMass() {
        return _getMMass(address);
    }
    private static native float _getMMass(long address);

    /**
     * @param value WebIDL type: float
     */
    public void setMMass(float value) {
        _setMMass(address, value);
    }
    private static native void _setMMass(long address, float value);

    /**
     * @return WebIDL type: {@link PxVec3} [Value]
     */
    public PxVec3 getMCMOffset() {
        return PxVec3.wrapPointer(_getMCMOffset(address));
    }
    private static native long _getMCMOffset(long address);

    /**
     * @param value WebIDL type: {@link PxVec3} [Value]
     */
    public void setMCMOffset(PxVec3 value) {
        _setMCMOffset(address, value.getAddress());
    }
    private static native void _setMCMOffset(long address, long value);

}
