package physx.vehicle;

import physx.NativeObject;

public class PxVehicleAutoBoxData extends NativeObject {

    public static PxVehicleAutoBoxData wrapPointer(long address) {
        return new PxVehicleAutoBoxData(address);
    }
    
    protected PxVehicleAutoBoxData(long address) {
        super(address);
    }

    // Constructors

    public PxVehicleAutoBoxData() {
        address = _PxVehicleAutoBoxData();
    }
    private static native long _PxVehicleAutoBoxData();

    // Destructor

    public void destroy() {
        if (address == 0L) {
            throw new IllegalStateException(this + " is already deleted");
        }
        if (isExternallyAllocated) {
            throw new IllegalStateException(this + " is externally allocated and cannot be manually destroyed");
        }
        _delete_native_instance(address);
        address = 0L;
    }
    private static native long _delete_native_instance(long address);

    // Attributes

    /**
     * @param index Array index
     * @return WebIDL type: float
     */
    public float getMUpRatios(int index) {
        return _getMUpRatios(address, index);
    }
    private static native float _getMUpRatios(long address, int index);

    /**
     * @param index Array index
     * @param value WebIDL type: float
     */
    public void setMUpRatios(int index, float value) {
        _setMUpRatios(address, index, value);
    }
    private static native void _setMUpRatios(long address, int index, float value);

    /**
     * @param index Array index
     * @return WebIDL type: float
     */
    public float getMDownRatios(int index) {
        return _getMDownRatios(address, index);
    }
    private static native float _getMDownRatios(long address, int index);

    /**
     * @param index Array index
     * @param value WebIDL type: float
     */
    public void setMDownRatios(int index, float value) {
        _setMDownRatios(address, index, value);
    }
    private static native void _setMDownRatios(long address, int index, float value);

    // Functions

    /**
     * @param latency WebIDL type: float
     */
    public void setLatency(float latency) {
        _setLatency(address, latency);
    }
    private static native void _setLatency(long address, float latency);

    /**
     * @return WebIDL type: float
     */
    public float getLatency() {
        return _getLatency(address);
    }
    private static native float _getLatency(long address);

    /**
     * @param a WebIDL type: {@link PxVehicleGearEnum} [enum]
     * @return WebIDL type: float
     */
    public float getUpRatios(int a) {
        return _getUpRatios(address, a);
    }
    private static native float _getUpRatios(long address, int a);

    /**
     * @param a     WebIDL type: {@link PxVehicleGearEnum} [enum]
     * @param ratio WebIDL type: float
     */
    public void setUpRatios(int a, float ratio) {
        _setUpRatios(address, a, ratio);
    }
    private static native void _setUpRatios(long address, int a, float ratio);

    /**
     * @param a WebIDL type: {@link PxVehicleGearEnum} [enum]
     * @return WebIDL type: float
     */
    public float getDownRatios(int a) {
        return _getDownRatios(address, a);
    }
    private static native float _getDownRatios(long address, int a);

    /**
     * @param a     WebIDL type: {@link PxVehicleGearEnum} [enum]
     * @param ratio WebIDL type: float
     */
    public void setDownRatios(int a, float ratio) {
        _setDownRatios(address, a, ratio);
    }
    private static native void _setDownRatios(long address, int a, float ratio);

}
