package physx.vehicle;

import physx.NativeObject;

public class PxVehicleAntiRollBarData extends NativeObject {

    public static PxVehicleAntiRollBarData wrapPointer(long address) {
        return new PxVehicleAntiRollBarData(address);
    }
    
    protected PxVehicleAntiRollBarData(long address) {
        super(address);
    }

    // Constructors

    public PxVehicleAntiRollBarData() {
        address = _PxVehicleAntiRollBarData();
    }
    private static native long _PxVehicleAntiRollBarData();

    // Destructor

    public void destroy() {
        if (address == 0L) {
            throw new IllegalStateException(this + " is already deleted");
        }
        if (isExternallyAllocated) {
            throw new IllegalStateException(this + " is externally allocated and cannot be manually destroyed");
        }
        _delete_native_instance(address);
        address = 0L;
    }
    private static native long _delete_native_instance(long address);

    // Attributes

    /**
     * @return WebIDL type: unsigned long
     */
    public int getMWheel0() {
        return _getMWheel0(address);
    }
    private static native int _getMWheel0(long address);

    /**
     * @param value WebIDL type: unsigned long
     */
    public void setMWheel0(int value) {
        _setMWheel0(address, value);
    }
    private static native void _setMWheel0(long address, int value);

    /**
     * @return WebIDL type: unsigned long
     */
    public int getMWheel1() {
        return _getMWheel1(address);
    }
    private static native int _getMWheel1(long address);

    /**
     * @param value WebIDL type: unsigned long
     */
    public void setMWheel1(int value) {
        _setMWheel1(address, value);
    }
    private static native void _setMWheel1(long address, int value);

    /**
     * @return WebIDL type: float
     */
    public float getMStiffness() {
        return _getMStiffness(address);
    }
    private static native float _getMStiffness(long address);

    /**
     * @param value WebIDL type: float
     */
    public void setMStiffness(float value) {
        _setMStiffness(address, value);
    }
    private static native void _setMStiffness(long address, float value);

}
