package physx.vehicle;

import physx.NativeObject;

public class PxVehicleAckermannGeometryData extends NativeObject {

    public static PxVehicleAckermannGeometryData wrapPointer(long address) {
        return new PxVehicleAckermannGeometryData(address);
    }
    
    protected PxVehicleAckermannGeometryData(long address) {
        super(address);
    }

    // Constructors

    public PxVehicleAckermannGeometryData() {
        address = _PxVehicleAckermannGeometryData();
    }
    private static native long _PxVehicleAckermannGeometryData();

    // Destructor

    public void destroy() {
        if (address == 0L) {
            throw new IllegalStateException(this + " is already deleted");
        }
        if (isExternallyAllocated) {
            throw new IllegalStateException(this + " is externally allocated and cannot be manually destroyed");
        }
        _delete_native_instance(address);
        address = 0L;
    }
    private static native long _delete_native_instance(long address);

    // Attributes

    /**
     * @return WebIDL type: float
     */
    public float getMAccuracy() {
        return _getMAccuracy(address);
    }
    private static native float _getMAccuracy(long address);

    /**
     * @param value WebIDL type: float
     */
    public void setMAccuracy(float value) {
        _setMAccuracy(address, value);
    }
    private static native void _setMAccuracy(long address, float value);

    /**
     * @return WebIDL type: float
     */
    public float getMFrontWidth() {
        return _getMFrontWidth(address);
    }
    private static native float _getMFrontWidth(long address);

    /**
     * @param value WebIDL type: float
     */
    public void setMFrontWidth(float value) {
        _setMFrontWidth(address, value);
    }
    private static native void _setMFrontWidth(long address, float value);

    /**
     * @return WebIDL type: float
     */
    public float getMRearWidth() {
        return _getMRearWidth(address);
    }
    private static native float _getMRearWidth(long address);

    /**
     * @param value WebIDL type: float
     */
    public void setMRearWidth(float value) {
        _setMRearWidth(address, value);
    }
    private static native void _setMRearWidth(long address, float value);

    /**
     * @return WebIDL type: float
     */
    public float getMAxleSeparation() {
        return _getMAxleSeparation(address);
    }
    private static native float _getMAxleSeparation(long address);

    /**
     * @param value WebIDL type: float
     */
    public void setMAxleSeparation(float value) {
        _setMAxleSeparation(address, value);
    }
    private static native void _setMAxleSeparation(long address, float value);

}
