package physx.support;

import physx.NativeObject;
import physx.physics.PxSweepQueryResult;

public class Vector_PxSweepQueryResult extends NativeObject {

    public static Vector_PxSweepQueryResult wrapPointer(long address) {
        return new Vector_PxSweepQueryResult(address);
    }
    
    protected Vector_PxSweepQueryResult(long address) {
        super(address);
    }

    // Constructors

    public Vector_PxSweepQueryResult() {
        address = _Vector_PxSweepQueryResult();
    }
    private static native long _Vector_PxSweepQueryResult();

    /**
     * @param size WebIDL type: unsigned long
     */
    public Vector_PxSweepQueryResult(int size) {
        address = _Vector_PxSweepQueryResult(size);
    }
    private static native long _Vector_PxSweepQueryResult(int size);

    // Destructor

    public void destroy() {
        if (address == 0L) {
            throw new IllegalStateException(this + " is already deleted");
        }
        if (isExternallyAllocated) {
            throw new IllegalStateException(this + " is externally allocated and cannot be manually destroyed");
        }
        _delete_native_instance(address);
        address = 0L;
    }
    private static native long _delete_native_instance(long address);

    // Functions

    /**
     * @param index WebIDL type: unsigned long
     * @return WebIDL type: {@link PxSweepQueryResult} [Ref]
     */
    public PxSweepQueryResult at(int index) {
        return PxSweepQueryResult.wrapPointer(_at(address, index));
    }
    private static native long _at(long address, int index);

    /**
     * @return WebIDL type: {@link PxSweepQueryResult}
     */
    public PxSweepQueryResult data() {
        return PxSweepQueryResult.wrapPointer(_data(address));
    }
    private static native long _data(long address);

    /**
     * @return WebIDL type: unsigned long
     */
    public int size() {
        return _size(address);
    }
    private static native int _size(long address);

    /**
     * @param value WebIDL type: {@link PxSweepQueryResult} [Ref]
     */
    public void push_back(PxSweepQueryResult value) {
        _push_back(address, value.getAddress());
    }
    private static native void _push_back(long address, long value);

}
