package physx.support;

import physx.NativeObject;
import physx.physics.PxRaycastQueryResult;

public class Vector_PxRaycastQueryResult extends NativeObject {

    public static Vector_PxRaycastQueryResult wrapPointer(long address) {
        return new Vector_PxRaycastQueryResult(address);
    }
    
    protected Vector_PxRaycastQueryResult(long address) {
        super(address);
    }

    // Constructors

    public Vector_PxRaycastQueryResult() {
        address = _Vector_PxRaycastQueryResult();
    }
    private static native long _Vector_PxRaycastQueryResult();

    /**
     * @param size WebIDL type: unsigned long
     */
    public Vector_PxRaycastQueryResult(int size) {
        address = _Vector_PxRaycastQueryResult(size);
    }
    private static native long _Vector_PxRaycastQueryResult(int size);

    // Destructor

    public void destroy() {
        if (address == 0L) {
            throw new IllegalStateException(this + " is already deleted");
        }
        if (isExternallyAllocated) {
            throw new IllegalStateException(this + " is externally allocated and cannot be manually destroyed");
        }
        _delete_native_instance(address);
        address = 0L;
    }
    private static native long _delete_native_instance(long address);

    // Functions

    /**
     * @param index WebIDL type: unsigned long
     * @return WebIDL type: {@link PxRaycastQueryResult} [Ref]
     */
    public PxRaycastQueryResult at(int index) {
        return PxRaycastQueryResult.wrapPointer(_at(address, index));
    }
    private static native long _at(long address, int index);

    /**
     * @return WebIDL type: {@link PxRaycastQueryResult}
     */
    public PxRaycastQueryResult data() {
        return PxRaycastQueryResult.wrapPointer(_data(address));
    }
    private static native long _data(long address);

    /**
     * @return WebIDL type: unsigned long
     */
    public int size() {
        return _size(address);
    }
    private static native int _size(long address);

    /**
     * @param value WebIDL type: {@link PxRaycastQueryResult} [Ref]
     */
    public void push_back(PxRaycastQueryResult value) {
        _push_back(address, value.getAddress());
    }
    private static native void _push_back(long address, long value);

}
