package physx.support;

import physx.NativeObject;
import physx.physics.PxMaterial;

public class Vector_PxMaterial extends NativeObject {

    public static Vector_PxMaterial wrapPointer(long address) {
        return new Vector_PxMaterial(address);
    }
    
    protected Vector_PxMaterial(long address) {
        super(address);
    }

    // Constructors

    public Vector_PxMaterial() {
        address = _Vector_PxMaterial();
    }
    private static native long _Vector_PxMaterial();

    /**
     * @param size WebIDL type: unsigned long
     */
    public Vector_PxMaterial(int size) {
        address = _Vector_PxMaterial(size);
    }
    private static native long _Vector_PxMaterial(int size);

    // Destructor

    public void destroy() {
        if (address == 0L) {
            throw new IllegalStateException(this + " is already deleted");
        }
        if (isExternallyAllocated) {
            throw new IllegalStateException(this + " is externally allocated and cannot be manually destroyed");
        }
        _delete_native_instance(address);
        address = 0L;
    }
    private static native long _delete_native_instance(long address);

    // Functions

    /**
     * @param index WebIDL type: unsigned long
     * @return WebIDL type: {@link PxMaterial} [Const]
     */
    public PxMaterial at(int index) {
        return PxMaterial.wrapPointer(_at(address, index));
    }
    private static native long _at(long address, int index);

    /**
     * @return WebIDL type: {@link PxMaterialPtr}
     */
    public PxMaterialPtr data() {
        return PxMaterialPtr.wrapPointer(_data(address));
    }
    private static native long _data(long address);

    /**
     * @return WebIDL type: unsigned long
     */
    public int size() {
        return _size(address);
    }
    private static native int _size(long address);

    /**
     * @param value WebIDL type: {@link PxMaterial}
     */
    public void push_back(PxMaterial value) {
        _push_back(address, value.getAddress());
    }
    private static native void _push_back(long address, long value);

}
