package physx.support;

import physx.NativeObject;

public class PxMaterialPtr extends NativeObject {

    protected PxMaterialPtr() { }

    public static PxMaterialPtr wrapPointer(long address) {
        return new PxMaterialPtr(address);
    }
    
    protected PxMaterialPtr(long address) {
        super(address);
    }

    // Destructor

    public void destroy() {
        if (address == 0L) {
            throw new IllegalStateException(this + " is already deleted");
        }
        if (isExternallyAllocated) {
            throw new IllegalStateException(this + " is externally allocated and cannot be manually destroyed");
        }
        _delete_native_instance(address);
        address = 0L;
    }
    private static native long _delete_native_instance(long address);

}
