package physx.physics;

import physx.NativeObject;
import physx.common.PxBaseTask;
import physx.common.PxVec3;
import physx.geomutils.PxBVHStructure;

public class PxScene extends NativeObject {

    protected PxScene() { }

    public static PxScene wrapPointer(long address) {
        return new PxScene(address);
    }
    
    protected PxScene(long address) {
        super(address);
    }

    // Functions

    /**
     * @param actor WebIDL type: {@link PxActor} [Ref]
     */
    public void addActor(PxActor actor) {
        _addActor(address, actor.getAddress());
    }
    private static native void _addActor(long address, long actor);

    /**
     * @param actor        WebIDL type: {@link PxActor} [Ref]
     * @param bvhStructure WebIDL type: {@link PxBVHStructure} [Const]
     */
    public void addActor(PxActor actor, PxBVHStructure bvhStructure) {
        _addActor(address, actor.getAddress(), bvhStructure.getAddress());
    }
    private static native void _addActor(long address, long actor, long bvhStructure);

    /**
     * @param actor WebIDL type: {@link PxActor} [Ref]
     */
    public void removeActor(PxActor actor) {
        _removeActor(address, actor.getAddress());
    }
    private static native void _removeActor(long address, long actor);

    /**
     * @param actor           WebIDL type: {@link PxActor} [Ref]
     * @param wakeOnLostTouch WebIDL type: boolean
     */
    public void removeActor(PxActor actor, boolean wakeOnLostTouch) {
        _removeActor(address, actor.getAddress(), wakeOnLostTouch);
    }
    private static native void _removeActor(long address, long actor, boolean wakeOnLostTouch);

    /**
     * @param elapsedTime WebIDL type: float
     */
    public void simulate(float elapsedTime) {
        _simulate(address, elapsedTime);
    }
    private static native void _simulate(long address, float elapsedTime);

    /**
     * @param elapsedTime    WebIDL type: float
     * @param completionTask WebIDL type: {@link PxBaseTask}
     */
    public void simulate(float elapsedTime, PxBaseTask completionTask) {
        _simulate(address, elapsedTime, completionTask.getAddress());
    }
    private static native void _simulate(long address, float elapsedTime, long completionTask);

    /**
     * @param elapsedTime     WebIDL type: float
     * @param completionTask  WebIDL type: {@link PxBaseTask}
     * @param scratchMemBlock WebIDL type: any
     */
    public void simulate(float elapsedTime, PxBaseTask completionTask, NativeObject scratchMemBlock) {
        _simulate(address, elapsedTime, completionTask.getAddress(), scratchMemBlock.getAddress());
    }
    private static native void _simulate(long address, float elapsedTime, long completionTask, long scratchMemBlock);

    /**
     * @param elapsedTime         WebIDL type: float
     * @param completionTask      WebIDL type: {@link PxBaseTask}
     * @param scratchMemBlock     WebIDL type: any
     * @param scratchMemBlockSize WebIDL type: unsigned long
     */
    public void simulate(float elapsedTime, PxBaseTask completionTask, NativeObject scratchMemBlock, int scratchMemBlockSize) {
        _simulate(address, elapsedTime, completionTask.getAddress(), scratchMemBlock.getAddress(), scratchMemBlockSize);
    }
    private static native void _simulate(long address, float elapsedTime, long completionTask, long scratchMemBlock, int scratchMemBlockSize);

    /**
     * @param elapsedTime         WebIDL type: float
     * @param completionTask      WebIDL type: {@link PxBaseTask}
     * @param scratchMemBlock     WebIDL type: any
     * @param scratchMemBlockSize WebIDL type: unsigned long
     * @param controlSimulation   WebIDL type: boolean
     */
    public void simulate(float elapsedTime, PxBaseTask completionTask, NativeObject scratchMemBlock, int scratchMemBlockSize, boolean controlSimulation) {
        _simulate(address, elapsedTime, completionTask.getAddress(), scratchMemBlock.getAddress(), scratchMemBlockSize, controlSimulation);
    }
    private static native void _simulate(long address, float elapsedTime, long completionTask, long scratchMemBlock, int scratchMemBlockSize, boolean controlSimulation);

    /**
     * @return WebIDL type: boolean
     */
    public boolean fetchResults() {
        return _fetchResults(address);
    }
    private static native boolean _fetchResults(long address);

    /**
     * @param block WebIDL type: boolean
     * @return WebIDL type: boolean
     */
    public boolean fetchResults(boolean block) {
        return _fetchResults(address, block);
    }
    private static native boolean _fetchResults(long address, boolean block);

    /**
     * @param vec WebIDL type: {@link PxVec3} [Const, Ref]
     */
    public void setGravity(PxVec3 vec) {
        _setGravity(address, vec.getAddress());
    }
    private static native void _setGravity(long address, long vec);

    /**
     * @return WebIDL type: {@link PxVec3} [Value]
     */
    public PxVec3 getGravity() {
        return PxVec3.wrapPointer(_getGravity(address));
    }
    private static native long _getGravity(long address);

    /**
     * @param desc WebIDL type: {@link PxBatchQueryDesc} [Const, Ref]
     * @return WebIDL type: {@link PxBatchQuery}
     */
    public PxBatchQuery createBatchQuery(PxBatchQueryDesc desc) {
        return PxBatchQuery.wrapPointer(_createBatchQuery(address, desc.getAddress()));
    }
    private static native long _createBatchQuery(long address, long desc);

    public void release() {
        _release(address);
    }
    private static native void _release(long address);

    /**
     * @param flag  WebIDL type: {@link PxSceneFlagEnum} [enum]
     * @param value WebIDL type: boolean
     */
    public void setFlag(int flag, boolean value) {
        _setFlag(address, flag, value);
    }
    private static native void _setFlag(long address, int flag, boolean value);

    /**
     * @return WebIDL type: {@link PxSceneFlags} [Value]
     */
    public PxSceneFlags getFlags() {
        return PxSceneFlags.wrapPointer(_getFlags(address));
    }
    private static native long _getFlags(long address);

    /**
     * @return WebIDL type: {@link PxPhysics} [Ref]
     */
    public PxPhysics getPhysics() {
        return PxPhysics.wrapPointer(_getPhysics(address));
    }
    private static native long _getPhysics(long address);

    /**
     * @return WebIDL type: unsigned long
     */
    public int getTimestamp() {
        return _getTimestamp(address);
    }
    private static native int _getTimestamp(long address);

}
