package physx.physics;

import physx.NativeObject;

public class PxRigidBodyFlags extends NativeObject {

    protected PxRigidBodyFlags() { }

    public static PxRigidBodyFlags wrapPointer(long address) {
        return new PxRigidBodyFlags(address);
    }
    
    protected PxRigidBodyFlags(long address) {
        super(address);
    }

    private static native int __sizeOf();
    public static final int SIZEOF = __sizeOf();
    public static final int ALIGNOF = 8;

    // Placed Constructors

    /**
     * @param address Pre-allocated memory, where the object is created.
     * @param flags   WebIDL type: octet
     * @return Stack allocated object of PxRigidBodyFlags
     */
    public static PxRigidBodyFlags createAt(long address, byte flags) {
        __placement_new_PxRigidBodyFlags(address, flags);
        PxRigidBodyFlags createdObj = wrapPointer(address);
        createdObj.isExternallyAllocated = true;
        return createdObj;
    }

    /**
     * @param <T>       Allocator class, e.g. LWJGL's MemoryStack.
     * @param allocator Object to use for allocation, e.g. an instance of LWJGL's MemoryStack.
     * @param allocate  Method to call on allocator to obtain the target address, e.g. MemoryStack::nmalloc.
     * @param flags     WebIDL type: octet
     * @return Stack allocated object of PxRigidBodyFlags
     */
    public static <T> PxRigidBodyFlags createAt(T allocator, Allocator<T> allocate, byte flags) {
        long address = allocate.on(allocator, ALIGNOF, SIZEOF); 
        __placement_new_PxRigidBodyFlags(address, flags);
        PxRigidBodyFlags createdObj = wrapPointer(address);
        createdObj.isExternallyAllocated = true;
        return createdObj;
    }

    private static native void __placement_new_PxRigidBodyFlags(long address, byte flags);

    // Constructors

    /**
     * @param flags WebIDL type: octet
     */
    public PxRigidBodyFlags(byte flags) {
        address = _PxRigidBodyFlags(flags);
    }
    private static native long _PxRigidBodyFlags(byte flags);

    // Destructor

    public void destroy() {
        if (address == 0L) {
            throw new IllegalStateException(this + " is already deleted");
        }
        if (isExternallyAllocated) {
            throw new IllegalStateException(this + " is externally allocated and cannot be manually destroyed");
        }
        _delete_native_instance(address);
        address = 0L;
    }
    private static native long _delete_native_instance(long address);

    // Functions

    /**
     * @param flag WebIDL type: {@link PxRigidBodyFlagEnum} [enum]
     * @return WebIDL type: boolean
     */
    public boolean isSet(int flag) {
        return _isSet(address, flag);
    }
    private static native boolean _isSet(long address, int flag);

    /**
     * @param flag WebIDL type: {@link PxRigidBodyFlagEnum} [enum]
     */
    public void set(int flag) {
        _set(address, flag);
    }
    private static native void _set(long address, int flag);

    /**
     * @param flag WebIDL type: {@link PxRigidBodyFlagEnum} [enum]
     */
    public void clear(int flag) {
        _clear(address, flag);
    }
    private static native void _clear(long address, int flag);

}
