package physx.physics;

import physx.common.PxTransform;
import physx.common.PxVec3;

public class PxRigidBody extends PxRigidActor {

    protected PxRigidBody() { }

    public static PxRigidBody wrapPointer(long address) {
        return new PxRigidBody(address);
    }
    
    protected PxRigidBody(long address) {
        super(address);
    }

    // Functions

    /**
     * @param pose WebIDL type: {@link PxTransform} [Const, Ref]
     */
    public void setCMassLocalPose(PxTransform pose) {
        _setCMassLocalPose(address, pose.getAddress());
    }
    private static native void _setCMassLocalPose(long address, long pose);

    /**
     * @return WebIDL type: {@link PxTransform} [Value]
     */
    public PxTransform getCMassLocalPose() {
        return PxTransform.wrapPointer(_getCMassLocalPose(address));
    }
    private static native long _getCMassLocalPose(long address);

    /**
     * @param mass WebIDL type: float
     */
    public void setMass(float mass) {
        _setMass(address, mass);
    }
    private static native void _setMass(long address, float mass);

    /**
     * @return WebIDL type: float
     */
    public float getMass() {
        return _getMass(address);
    }
    private static native float _getMass(long address);

    /**
     * @return WebIDL type: float
     */
    public float getInvMass() {
        return _getInvMass(address);
    }
    private static native float _getInvMass(long address);

    /**
     * @param m WebIDL type: {@link PxVec3} [Const, Ref]
     */
    public void setMassSpaceInertiaTensor(PxVec3 m) {
        _setMassSpaceInertiaTensor(address, m.getAddress());
    }
    private static native void _setMassSpaceInertiaTensor(long address, long m);

    /**
     * @return WebIDL type: {@link PxVec3} [Value]
     */
    public PxVec3 getMassSpaceInertiaTensor() {
        return PxVec3.wrapPointer(_getMassSpaceInertiaTensor(address));
    }
    private static native long _getMassSpaceInertiaTensor(long address);

    /**
     * @return WebIDL type: {@link PxVec3} [Value]
     */
    public PxVec3 getMassSpaceInvInertiaTensor() {
        return PxVec3.wrapPointer(_getMassSpaceInvInertiaTensor(address));
    }
    private static native long _getMassSpaceInvInertiaTensor(long address);

    /**
     * @param linDamp WebIDL type: float
     */
    public void setLinearDamping(float linDamp) {
        _setLinearDamping(address, linDamp);
    }
    private static native void _setLinearDamping(long address, float linDamp);

    /**
     * @return WebIDL type: float
     */
    public float getLinearDamping() {
        return _getLinearDamping(address);
    }
    private static native float _getLinearDamping(long address);

    /**
     * @param angDamp WebIDL type: float
     */
    public void setAngularDamping(float angDamp) {
        _setAngularDamping(address, angDamp);
    }
    private static native void _setAngularDamping(long address, float angDamp);

    /**
     * @return WebIDL type: float
     */
    public float getAngularDamping() {
        return _getAngularDamping(address);
    }
    private static native float _getAngularDamping(long address);

    /**
     * @return WebIDL type: {@link PxVec3} [Value]
     */
    public PxVec3 getLinearVelocity() {
        return PxVec3.wrapPointer(_getLinearVelocity(address));
    }
    private static native long _getLinearVelocity(long address);

    /**
     * @param linVel WebIDL type: {@link PxVec3} [Const, Ref]
     */
    public void setLinearVelocity(PxVec3 linVel) {
        _setLinearVelocity(address, linVel.getAddress());
    }
    private static native void _setLinearVelocity(long address, long linVel);

    /**
     * @param linVel   WebIDL type: {@link PxVec3} [Const, Ref]
     * @param autowake WebIDL type: boolean
     */
    public void setLinearVelocity(PxVec3 linVel, boolean autowake) {
        _setLinearVelocity(address, linVel.getAddress(), autowake);
    }
    private static native void _setLinearVelocity(long address, long linVel, boolean autowake);

    /**
     * @return WebIDL type: {@link PxVec3} [Value]
     */
    public PxVec3 getAngularVelocity() {
        return PxVec3.wrapPointer(_getAngularVelocity(address));
    }
    private static native long _getAngularVelocity(long address);

    /**
     * @param angVel WebIDL type: {@link PxVec3} [Const, Ref]
     */
    public void setAngularVelocity(PxVec3 angVel) {
        _setAngularVelocity(address, angVel.getAddress());
    }
    private static native void _setAngularVelocity(long address, long angVel);

    /**
     * @param angVel   WebIDL type: {@link PxVec3} [Const, Ref]
     * @param autowake WebIDL type: boolean
     */
    public void setAngularVelocity(PxVec3 angVel, boolean autowake) {
        _setAngularVelocity(address, angVel.getAddress(), autowake);
    }
    private static native void _setAngularVelocity(long address, long angVel, boolean autowake);

    /**
     * @return WebIDL type: float
     */
    public float getMaxLinearVelocity() {
        return _getMaxLinearVelocity(address);
    }
    private static native float _getMaxLinearVelocity(long address);

    /**
     * @param maxLinVel WebIDL type: float
     */
    public void setMaxLinearVelocity(float maxLinVel) {
        _setMaxLinearVelocity(address, maxLinVel);
    }
    private static native void _setMaxLinearVelocity(long address, float maxLinVel);

    /**
     * @return WebIDL type: float
     */
    public float getMaxAngularVelocity() {
        return _getMaxAngularVelocity(address);
    }
    private static native float _getMaxAngularVelocity(long address);

    /**
     * @param maxAngVel WebIDL type: float
     */
    public void setMaxAngularVelocity(float maxAngVel) {
        _setMaxAngularVelocity(address, maxAngVel);
    }
    private static native void _setMaxAngularVelocity(long address, float maxAngVel);

    /**
     * @param force WebIDL type: {@link PxVec3} [Const, Ref]
     */
    public void addForce(PxVec3 force) {
        _addForce(address, force.getAddress());
    }
    private static native void _addForce(long address, long force);

    /**
     * @param force WebIDL type: {@link PxVec3} [Const, Ref]
     * @param mode  WebIDL type: {@link PxForceModeEnum} [enum]
     */
    public void addForce(PxVec3 force, int mode) {
        _addForce(address, force.getAddress(), mode);
    }
    private static native void _addForce(long address, long force, int mode);

    /**
     * @param force    WebIDL type: {@link PxVec3} [Const, Ref]
     * @param mode     WebIDL type: {@link PxForceModeEnum} [enum]
     * @param autowake WebIDL type: boolean
     */
    public void addForce(PxVec3 force, int mode, boolean autowake) {
        _addForce(address, force.getAddress(), mode, autowake);
    }
    private static native void _addForce(long address, long force, int mode, boolean autowake);

    /**
     * @param torque WebIDL type: {@link PxVec3} [Const, Ref]
     */
    public void addTorque(PxVec3 torque) {
        _addTorque(address, torque.getAddress());
    }
    private static native void _addTorque(long address, long torque);

    /**
     * @param torque WebIDL type: {@link PxVec3} [Const, Ref]
     * @param mode   WebIDL type: {@link PxForceModeEnum} [enum]
     */
    public void addTorque(PxVec3 torque, int mode) {
        _addTorque(address, torque.getAddress(), mode);
    }
    private static native void _addTorque(long address, long torque, int mode);

    /**
     * @param torque   WebIDL type: {@link PxVec3} [Const, Ref]
     * @param mode     WebIDL type: {@link PxForceModeEnum} [enum]
     * @param autowake WebIDL type: boolean
     */
    public void addTorque(PxVec3 torque, int mode, boolean autowake) {
        _addTorque(address, torque.getAddress(), mode, autowake);
    }
    private static native void _addTorque(long address, long torque, int mode, boolean autowake);

    /**
     * @param mode WebIDL type: {@link PxForceModeEnum} [enum]
     */
    public void clearForce(int mode) {
        _clearForce(address, mode);
    }
    private static native void _clearForce(long address, int mode);

    /**
     * @param mode WebIDL type: {@link PxForceModeEnum} [enum]
     */
    public void clearTorque(int mode) {
        _clearTorque(address, mode);
    }
    private static native void _clearTorque(long address, int mode);

    /**
     * @param force  WebIDL type: {@link PxVec3} [Const, Ref]
     * @param torque WebIDL type: {@link PxVec3} [Const, Ref]
     */
    public void setForceAndTorque(PxVec3 force, PxVec3 torque) {
        _setForceAndTorque(address, force.getAddress(), torque.getAddress());
    }
    private static native void _setForceAndTorque(long address, long force, long torque);

    /**
     * @param force  WebIDL type: {@link PxVec3} [Const, Ref]
     * @param torque WebIDL type: {@link PxVec3} [Const, Ref]
     * @param mode   WebIDL type: {@link PxForceModeEnum} [enum]
     */
    public void setForceAndTorque(PxVec3 force, PxVec3 torque, int mode) {
        _setForceAndTorque(address, force.getAddress(), torque.getAddress(), mode);
    }
    private static native void _setForceAndTorque(long address, long force, long torque, int mode);

    /**
     * @param flag  WebIDL type: {@link PxRigidBodyFlagEnum} [enum]
     * @param value WebIDL type: boolean
     */
    public void setRigidBodyFlag(int flag, boolean value) {
        _setRigidBodyFlag(address, flag, value);
    }
    private static native void _setRigidBodyFlag(long address, int flag, boolean value);

    /**
     * @param inFlags WebIDL type: {@link PxRigidBodyFlags} [Ref]
     */
    public void setRigidBodyFlags(PxRigidBodyFlags inFlags) {
        _setRigidBodyFlags(address, inFlags.getAddress());
    }
    private static native void _setRigidBodyFlags(long address, long inFlags);

    /**
     * @return WebIDL type: {@link PxRigidBodyFlags} [Value]
     */
    public PxRigidBodyFlags getRigidBodyFlags() {
        return PxRigidBodyFlags.wrapPointer(_getRigidBodyFlags(address));
    }
    private static native long _getRigidBodyFlags(long address);

    /**
     * @param advanceCoefficient WebIDL type: float
     */
    public void setMinCCDAdvanceCoefficient(float advanceCoefficient) {
        _setMinCCDAdvanceCoefficient(address, advanceCoefficient);
    }
    private static native void _setMinCCDAdvanceCoefficient(long address, float advanceCoefficient);

    /**
     * @return WebIDL type: float
     */
    public float getMinCCDAdvanceCoefficient() {
        return _getMinCCDAdvanceCoefficient(address);
    }
    private static native float _getMinCCDAdvanceCoefficient(long address);

    /**
     * @param biasClamp WebIDL type: float
     */
    public void setMaxDepenetrationVelocity(float biasClamp) {
        _setMaxDepenetrationVelocity(address, biasClamp);
    }
    private static native void _setMaxDepenetrationVelocity(long address, float biasClamp);

    /**
     * @return WebIDL type: float
     */
    public float getMaxDepenetrationVelocity() {
        return _getMaxDepenetrationVelocity(address);
    }
    private static native float _getMaxDepenetrationVelocity(long address);

    /**
     * @param maxImpulse WebIDL type: float
     */
    public void setMaxContactImpulse(float maxImpulse) {
        _setMaxContactImpulse(address, maxImpulse);
    }
    private static native void _setMaxContactImpulse(long address, float maxImpulse);

    /**
     * @return WebIDL type: float
     */
    public float getMaxContactImpulse() {
        return _getMaxContactImpulse(address);
    }
    private static native float _getMaxContactImpulse(long address);

    /**
     * @return WebIDL type: unsigned long
     */
    public int getInternalIslandNodeIndex() {
        return _getInternalIslandNodeIndex(address);
    }
    private static native int _getInternalIslandNodeIndex(long address);

}
