package physx.physics;

import physx.common.PxTransform;

public class PxRigidActor extends PxActor {

    protected PxRigidActor() { }

    public static PxRigidActor wrapPointer(long address) {
        return new PxRigidActor(address);
    }
    
    protected PxRigidActor(long address) {
        super(address);
    }

    // Functions

    /**
     * @return WebIDL type: {@link PxTransform} [Value]
     */
    public PxTransform getGlobalPose() {
        return PxTransform.wrapPointer(_getGlobalPose(address));
    }
    private static native long _getGlobalPose(long address);

    /**
     * @param pose WebIDL type: {@link PxTransform} [Const, Ref]
     */
    public void setGlobalPose(PxTransform pose) {
        _setGlobalPose(address, pose.getAddress());
    }
    private static native void _setGlobalPose(long address, long pose);

    /**
     * @param pose     WebIDL type: {@link PxTransform} [Const, Ref]
     * @param autowake WebIDL type: boolean
     */
    public void setGlobalPose(PxTransform pose, boolean autowake) {
        _setGlobalPose(address, pose.getAddress(), autowake);
    }
    private static native void _setGlobalPose(long address, long pose, boolean autowake);

    /**
     * @param shape WebIDL type: {@link PxShape} [Ref]
     * @return WebIDL type: boolean
     */
    public boolean attachShape(PxShape shape) {
        return _attachShape(address, shape.getAddress());
    }
    private static native boolean _attachShape(long address, long shape);

    /**
     * @param shape WebIDL type: {@link PxShape} [Ref]
     */
    public void detachShape(PxShape shape) {
        _detachShape(address, shape.getAddress());
    }
    private static native void _detachShape(long address, long shape);

    /**
     * @param shape           WebIDL type: {@link PxShape} [Ref]
     * @param wakeOnLostTouch WebIDL type: boolean
     */
    public void detachShape(PxShape shape, boolean wakeOnLostTouch) {
        _detachShape(address, shape.getAddress(), wakeOnLostTouch);
    }
    private static native void _detachShape(long address, long shape, boolean wakeOnLostTouch);

    /**
     * @return WebIDL type: long
     */
    public int getNbShapes() {
        return _getNbShapes(address);
    }
    private static native int _getNbShapes(long address);

}
