package physx.physics;


public class PxQueryHit extends PxActorShape {

    protected PxQueryHit() { }

    public static PxQueryHit wrapPointer(long address) {
        return new PxQueryHit(address);
    }
    
    protected PxQueryHit(long address) {
        super(address);
    }

    // Destructor

    public void destroy() {
        if (address == 0L) {
            throw new IllegalStateException(this + " is already deleted");
        }
        if (isExternallyAllocated) {
            throw new IllegalStateException(this + " is externally allocated and cannot be manually destroyed");
        }
        _delete_native_instance(address);
        address = 0L;
    }
    private static native long _delete_native_instance(long address);

    // Attributes

    /**
     * @return WebIDL type: unsigned long
     */
    public int getFaceIndex() {
        return _getFaceIndex(address);
    }
    private static native int _getFaceIndex(long address);

    /**
     * @param value WebIDL type: unsigned long
     */
    public void setFaceIndex(int value) {
        _setFaceIndex(address, value);
    }
    private static native void _setFaceIndex(long address, int value);

}
