package physx.physics;

import physx.NativeObject;
import physx.common.PxFoundation;
import physx.common.PxPhysicsInsertionCallback;
import physx.common.PxTolerancesScale;
import physx.common.PxTransform;
import physx.geomutils.PxGeometry;

public class PxPhysics extends NativeObject {

    protected PxPhysics() { }

    public static PxPhysics wrapPointer(long address) {
        return new PxPhysics(address);
    }
    
    protected PxPhysics(long address) {
        super(address);
    }

    // Destructor

    public void destroy() {
        if (address == 0L) {
            throw new IllegalStateException(this + " is already deleted");
        }
        if (isExternallyAllocated) {
            throw new IllegalStateException(this + " is externally allocated and cannot be manually destroyed");
        }
        _delete_native_instance(address);
        address = 0L;
    }
    private static native long _delete_native_instance(long address);

    // Functions

    public void release() {
        _release(address);
    }
    private static native void _release(long address);

    /**
     * @return WebIDL type: {@link PxFoundation} [Ref]
     */
    public PxFoundation getFoundation() {
        return PxFoundation.wrapPointer(_getFoundation(address));
    }
    private static native long _getFoundation(long address);

    /**
     * @return WebIDL type: {@link PxTolerancesScale} [Const, Ref]
     */
    public PxTolerancesScale getTolerancesScale() {
        return PxTolerancesScale.wrapPointer(_getTolerancesScale(address));
    }
    private static native long _getTolerancesScale(long address);

    /**
     * @param sceneDesc WebIDL type: {@link PxSceneDesc} [Const, Ref]
     * @return WebIDL type: {@link PxScene}
     */
    public PxScene createScene(PxSceneDesc sceneDesc) {
        return PxScene.wrapPointer(_createScene(address, sceneDesc.getAddress()));
    }
    private static native long _createScene(long address, long sceneDesc);

    /**
     * @param pose WebIDL type: {@link PxTransform} [Const, Ref]
     * @return WebIDL type: {@link PxRigidStatic}
     */
    public PxRigidStatic createRigidStatic(PxTransform pose) {
        return PxRigidStatic.wrapPointer(_createRigidStatic(address, pose.getAddress()));
    }
    private static native long _createRigidStatic(long address, long pose);

    /**
     * @param pose WebIDL type: {@link PxTransform} [Const, Ref]
     * @return WebIDL type: {@link PxRigidDynamic}
     */
    public PxRigidDynamic createRigidDynamic(PxTransform pose) {
        return PxRigidDynamic.wrapPointer(_createRigidDynamic(address, pose.getAddress()));
    }
    private static native long _createRigidDynamic(long address, long pose);

    /**
     * @param geometry WebIDL type: {@link PxGeometry} [Const, Ref]
     * @param material WebIDL type: {@link PxMaterial} [Const, Ref]
     * @return WebIDL type: {@link PxShape}
     */
    public PxShape createShape(PxGeometry geometry, PxMaterial material) {
        return PxShape.wrapPointer(_createShape(address, geometry.getAddress(), material.getAddress()));
    }
    private static native long _createShape(long address, long geometry, long material);

    /**
     * @param geometry    WebIDL type: {@link PxGeometry} [Const, Ref]
     * @param material    WebIDL type: {@link PxMaterial} [Const, Ref]
     * @param isExclusive WebIDL type: boolean
     * @return WebIDL type: {@link PxShape}
     */
    public PxShape createShape(PxGeometry geometry, PxMaterial material, boolean isExclusive) {
        return PxShape.wrapPointer(_createShape(address, geometry.getAddress(), material.getAddress(), isExclusive));
    }
    private static native long _createShape(long address, long geometry, long material, boolean isExclusive);

    /**
     * @param geometry    WebIDL type: {@link PxGeometry} [Const, Ref]
     * @param material    WebIDL type: {@link PxMaterial} [Const, Ref]
     * @param isExclusive WebIDL type: boolean
     * @param shapeFlags  WebIDL type: {@link PxShapeFlags} [Ref]
     * @return WebIDL type: {@link PxShape}
     */
    public PxShape createShape(PxGeometry geometry, PxMaterial material, boolean isExclusive, PxShapeFlags shapeFlags) {
        return PxShape.wrapPointer(_createShape(address, geometry.getAddress(), material.getAddress(), isExclusive, shapeFlags.getAddress()));
    }
    private static native long _createShape(long address, long geometry, long material, boolean isExclusive, long shapeFlags);

    /**
     * @return WebIDL type: long
     */
    public int getNbShapes() {
        return _getNbShapes(address);
    }
    private static native int _getNbShapes(long address);

    /**
     * @param staticFriction  WebIDL type: float
     * @param dynamicFriction WebIDL type: float
     * @param restitution     WebIDL type: float
     * @return WebIDL type: {@link PxMaterial}
     */
    public PxMaterial createMaterial(float staticFriction, float dynamicFriction, float restitution) {
        return PxMaterial.wrapPointer(_createMaterial(address, staticFriction, dynamicFriction, restitution));
    }
    private static native long _createMaterial(long address, float staticFriction, float dynamicFriction, float restitution);

    /**
     * @return WebIDL type: {@link PxPhysicsInsertionCallback} [Ref]
     */
    public PxPhysicsInsertionCallback getPhysicsInsertionCallback() {
        return PxPhysicsInsertionCallback.wrapPointer(_getPhysicsInsertionCallback(address));
    }
    private static native long _getPhysicsInsertionCallback(long address);

}
