package physx.physics;

import physx.NativeObject;

public class PxContactPairHeaderFlags extends NativeObject {

    protected PxContactPairHeaderFlags() { }

    public static PxContactPairHeaderFlags wrapPointer(long address) {
        return new PxContactPairHeaderFlags(address);
    }
    
    protected PxContactPairHeaderFlags(long address) {
        super(address);
    }

    // Constructors

    /**
     * @param flags WebIDL type: unsigned short
     */
    public PxContactPairHeaderFlags(short flags) {
        address = _PxContactPairHeaderFlags(flags);
    }
    private static native long _PxContactPairHeaderFlags(short flags);

    // Destructor

    public void destroy() {
        if (address == 0L) {
            throw new IllegalStateException(this + " is already deleted");
        }
        if (isExternallyAllocated) {
            throw new IllegalStateException(this + " is externally allocated and cannot be manually destroyed");
        }
        _delete_native_instance(address);
        address = 0L;
    }
    private static native long _delete_native_instance(long address);

    // Functions

    /**
     * @param flag WebIDL type: {@link PxContactPairHeaderFlagEnum} [enum]
     * @return WebIDL type: boolean
     */
    public boolean isSet(int flag) {
        return _isSet(address, flag);
    }
    private static native boolean _isSet(long address, int flag);

    /**
     * @param flag WebIDL type: {@link PxContactPairHeaderFlagEnum} [enum]
     */
    public void set(int flag) {
        _set(address, flag);
    }
    private static native void _set(long address, int flag);

    /**
     * @param flag WebIDL type: {@link PxContactPairHeaderFlagEnum} [enum]
     */
    public void clear(int flag) {
        _clear(address, flag);
    }
    private static native void _clear(long address, int flag);

}
