package physx.physics;

import physx.NativeObject;

public class PxContactPair extends NativeObject {

    protected PxContactPair() { }

    public static PxContactPair wrapPointer(long address) {
        return new PxContactPair(address);
    }
    
    protected PxContactPair(long address) {
        super(address);
    }

    // Destructor

    public void destroy() {
        if (address == 0L) {
            throw new IllegalStateException(this + " is already deleted");
        }
        if (isExternallyAllocated) {
            throw new IllegalStateException(this + " is externally allocated and cannot be manually destroyed");
        }
        _delete_native_instance(address);
        address = 0L;
    }
    private static native long _delete_native_instance(long address);

    // Attributes

    /**
     * @param index Array index
     * @return WebIDL type: {@link PxShape}
     */
    public PxShape getShapes(int index) {
        return PxShape.wrapPointer(_getShapes(address, index));
    }
    private static native long _getShapes(long address, int index);

    /**
     * @param index Array index
     * @param value WebIDL type: {@link PxShape}
     */
    public void setShapes(int index, PxShape value) {
        _setShapes(address, index, value.getAddress());
    }
    private static native void _setShapes(long address, int index, long value);

    /**
     * @return WebIDL type: octet
     */
    public byte getContactCount() {
        return _getContactCount(address);
    }
    private static native byte _getContactCount(long address);

    /**
     * @param value WebIDL type: octet
     */
    public void setContactCount(byte value) {
        _setContactCount(address, value);
    }
    private static native void _setContactCount(long address, byte value);

    /**
     * @return WebIDL type: octet
     */
    public byte getPatchCount() {
        return _getPatchCount(address);
    }
    private static native byte _getPatchCount(long address);

    /**
     * @param value WebIDL type: octet
     */
    public void setPatchCount(byte value) {
        _setPatchCount(address, value);
    }
    private static native void _setPatchCount(long address, byte value);

    /**
     * @return WebIDL type: {@link PxContactPairFlags} [Value]
     */
    public PxContactPairFlags getFlags() {
        return PxContactPairFlags.wrapPointer(_getFlags(address));
    }
    private static native long _getFlags(long address);

    /**
     * @param value WebIDL type: {@link PxContactPairFlags} [Value]
     */
    public void setFlags(PxContactPairFlags value) {
        _setFlags(address, value.getAddress());
    }
    private static native void _setFlags(long address, long value);

    /**
     * @return WebIDL type: {@link PxPairFlags} [Value]
     */
    public PxPairFlags getEvents() {
        return PxPairFlags.wrapPointer(_getEvents(address));
    }
    private static native long _getEvents(long address);

    /**
     * @param value WebIDL type: {@link PxPairFlags} [Value]
     */
    public void setEvents(PxPairFlags value) {
        _setEvents(address, value.getAddress());
    }
    private static native void _setEvents(long address, long value);

}
