package physx.physics;

import physx.NativeObject;

public class PxConstraintFlags extends NativeObject {

    protected PxConstraintFlags() { }

    public static PxConstraintFlags wrapPointer(long address) {
        return new PxConstraintFlags(address);
    }
    
    protected PxConstraintFlags(long address) {
        super(address);
    }

    // Constructors

    /**
     * @param flags WebIDL type: unsigned short
     */
    public PxConstraintFlags(short flags) {
        address = _PxConstraintFlags(flags);
    }
    private static native long _PxConstraintFlags(short flags);

    // Destructor

    public void destroy() {
        if (address == 0L) {
            throw new IllegalStateException(this + " is already deleted");
        }
        if (isExternallyAllocated) {
            throw new IllegalStateException(this + " is externally allocated and cannot be manually destroyed");
        }
        _delete_native_instance(address);
        address = 0L;
    }
    private static native long _delete_native_instance(long address);

    // Functions

    /**
     * @param flag WebIDL type: {@link PxConstraintFlagEnum} [enum]
     * @return WebIDL type: boolean
     */
    public boolean isSet(int flag) {
        return _isSet(address, flag);
    }
    private static native boolean _isSet(long address, int flag);

    /**
     * @param flag WebIDL type: {@link PxConstraintFlagEnum} [enum]
     */
    public void set(int flag) {
        _set(address, flag);
    }
    private static native void _set(long address, int flag);

    /**
     * @param flag WebIDL type: {@link PxConstraintFlagEnum} [enum]
     */
    public void clear(int flag) {
        _clear(address, flag);
    }
    private static native void _clear(long address, int flag);

}
