package physx.physics;

import physx.common.PxBase;
import physx.common.PxVec3;

public class PxConstraint extends PxBase {

    protected PxConstraint() { }

    public static PxConstraint wrapPointer(long address) {
        return new PxConstraint(address);
    }
    
    protected PxConstraint(long address) {
        super(address);
    }

    // Functions

    public void release() {
        _release(address);
    }
    private static native void _release(long address);

    /**
     * @return WebIDL type: {@link PxScene}
     */
    public PxScene getScene() {
        return PxScene.wrapPointer(_getScene(address));
    }
    private static native long _getScene(long address);

    /**
     * @param actor0 WebIDL type: {@link PxRigidActor}
     * @param actor1 WebIDL type: {@link PxRigidActor}
     */
    public void setActors(PxRigidActor actor0, PxRigidActor actor1) {
        _setActors(address, actor0.getAddress(), actor1.getAddress());
    }
    private static native void _setActors(long address, long actor0, long actor1);

    public void markDirty() {
        _markDirty(address);
    }
    private static native void _markDirty(long address);

    /**
     * @param flags WebIDL type: {@link PxConstraintFlags} [Ref]
     */
    public void setFlags(PxConstraintFlags flags) {
        _setFlags(address, flags.getAddress());
    }
    private static native void _setFlags(long address, long flags);

    /**
     * @return WebIDL type: {@link PxConstraintFlags} [Value]
     */
    public PxConstraintFlags getFlags() {
        return PxConstraintFlags.wrapPointer(_getFlags(address));
    }
    private static native long _getFlags(long address);

    /**
     * @param flag  WebIDL type: {@link PxConstraintFlagEnum} [enum]
     * @param value WebIDL type: boolean
     */
    public void setFlag(int flag, boolean value) {
        _setFlag(address, flag, value);
    }
    private static native void _setFlag(long address, int flag, boolean value);

    /**
     * @param linear  WebIDL type: {@link PxVec3} [Ref]
     * @param angular WebIDL type: {@link PxVec3} [Ref]
     */
    public void getForce(PxVec3 linear, PxVec3 angular) {
        _getForce(address, linear.getAddress(), angular.getAddress());
    }
    private static native void _getForce(long address, long linear, long angular);

    /**
     * @return WebIDL type: boolean
     */
    public boolean isValid() {
        return _isValid(address);
    }
    private static native boolean _isValid(long address);

    /**
     * @param linear  WebIDL type: float
     * @param angular WebIDL type: float
     */
    public void setBreakForce(float linear, float angular) {
        _setBreakForce(address, linear, angular);
    }
    private static native void _setBreakForce(long address, float linear, float angular);

    /**
     * @param threshold WebIDL type: float
     */
    public void setMinResponseThreshold(float threshold) {
        _setMinResponseThreshold(address, threshold);
    }
    private static native void _setMinResponseThreshold(long address, float threshold);

    /**
     * @return WebIDL type: float
     */
    public float getMinResponseThreshold() {
        return _getMinResponseThreshold(address);
    }
    private static native float _getMinResponseThreshold(long address);

}
