package physx.physics;

import physx.NativeObject;

public class PxBatchQueryDesc extends NativeObject {

    protected PxBatchQueryDesc() { }

    public static PxBatchQueryDesc wrapPointer(long address) {
        return new PxBatchQueryDesc(address);
    }
    
    protected PxBatchQueryDesc(long address) {
        super(address);
    }

    // Constructors

    /**
     * @param maxRaycastsPerExecute WebIDL type: unsigned long
     * @param maxSweepsPerExecute   WebIDL type: unsigned long
     * @param maxOverlapsPerExecute WebIDL type: unsigned long
     */
    public PxBatchQueryDesc(int maxRaycastsPerExecute, int maxSweepsPerExecute, int maxOverlapsPerExecute) {
        address = _PxBatchQueryDesc(maxRaycastsPerExecute, maxSweepsPerExecute, maxOverlapsPerExecute);
    }
    private static native long _PxBatchQueryDesc(int maxRaycastsPerExecute, int maxSweepsPerExecute, int maxOverlapsPerExecute);

    // Destructor

    public void destroy() {
        if (address == 0L) {
            throw new IllegalStateException(this + " is already deleted");
        }
        if (isExternallyAllocated) {
            throw new IllegalStateException(this + " is externally allocated and cannot be manually destroyed");
        }
        _delete_native_instance(address);
        address = 0L;
    }
    private static native long _delete_native_instance(long address);

    // Attributes

    /**
     * @return WebIDL type: any
     */
    public NativeObject getFilterShaderData() {
        return NativeObject.wrapPointer(_getFilterShaderData(address));
    }
    private static native long _getFilterShaderData(long address);

    /**
     * @param value WebIDL type: any
     */
    public void setFilterShaderData(NativeObject value) {
        _setFilterShaderData(address, value.getAddress());
    }
    private static native void _setFilterShaderData(long address, long value);

    /**
     * @return WebIDL type: unsigned long
     */
    public int getFilterShaderDataSize() {
        return _getFilterShaderDataSize(address);
    }
    private static native int _getFilterShaderDataSize(long address);

    /**
     * @param value WebIDL type: unsigned long
     */
    public void setFilterShaderDataSize(int value) {
        _setFilterShaderDataSize(address, value);
    }
    private static native void _setFilterShaderDataSize(long address, int value);

    /**
     * @return WebIDL type: {@link PxBatchQueryPreFilterShader} [Value]
     */
    public PxBatchQueryPreFilterShader getPreFilterShader() {
        long tmp = _getPreFilterShader(address);
        return (tmp != 0L ? PxBatchQueryPreFilterShader.wrapPointer(tmp) : null);
    }
    private static native long _getPreFilterShader(long address);

    /**
     * @param value WebIDL type: {@link PxBatchQueryPreFilterShader} [Value]
     */
    public void setPreFilterShader(PxBatchQueryPreFilterShader value) {
        _setPreFilterShader(address, (value != null ? value.getAddress() : 0L));
    }
    private static native void _setPreFilterShader(long address, long value);

    /**
     * @return WebIDL type: {@link PxBatchQueryPostFilterShader} [Value]
     */
    public PxBatchQueryPostFilterShader getPostFilterShader() {
        long tmp = _getPostFilterShader(address);
        return (tmp != 0L ? PxBatchQueryPostFilterShader.wrapPointer(tmp) : null);
    }
    private static native long _getPostFilterShader(long address);

    /**
     * @param value WebIDL type: {@link PxBatchQueryPostFilterShader} [Value]
     */
    public void setPostFilterShader(PxBatchQueryPostFilterShader value) {
        _setPostFilterShader(address, (value != null ? value.getAddress() : 0L));
    }
    private static native void _setPostFilterShader(long address, long value);

    /**
     * @return WebIDL type: {@link PxBatchQueryMemory} [Value]
     */
    public PxBatchQueryMemory getQueryMemory() {
        return PxBatchQueryMemory.wrapPointer(_getQueryMemory(address));
    }
    private static native long _getQueryMemory(long address);

    /**
     * @param value WebIDL type: {@link PxBatchQueryMemory} [Value]
     */
    public void setQueryMemory(PxBatchQueryMemory value) {
        _setQueryMemory(address, value.getAddress());
    }
    private static native void _setQueryMemory(long address, long value);

    // Functions

    /**
     * @return WebIDL type: boolean
     */
    public boolean isValid() {
        return _isValid(address);
    }
    private static native boolean _isValid(long address);

}
