package physx.physics;

import physx.NativeObject;

public class PxActorShape extends NativeObject {

    protected PxActorShape() { }

    public static PxActorShape wrapPointer(long address) {
        return new PxActorShape(address);
    }
    
    protected PxActorShape(long address) {
        super(address);
    }

    // Destructor

    public void destroy() {
        if (address == 0L) {
            throw new IllegalStateException(this + " is already deleted");
        }
        if (isExternallyAllocated) {
            throw new IllegalStateException(this + " is externally allocated and cannot be manually destroyed");
        }
        _delete_native_instance(address);
        address = 0L;
    }
    private static native long _delete_native_instance(long address);

    // Attributes

    /**
     * @return WebIDL type: {@link PxRigidActor}
     */
    public PxRigidActor getActor() {
        return PxRigidActor.wrapPointer(_getActor(address));
    }
    private static native long _getActor(long address);

    /**
     * @param value WebIDL type: {@link PxRigidActor}
     */
    public void setActor(PxRigidActor value) {
        _setActor(address, value.getAddress());
    }
    private static native void _setActor(long address, long value);

    /**
     * @return WebIDL type: {@link PxShape}
     */
    public PxShape getShape() {
        return PxShape.wrapPointer(_getShape(address));
    }
    private static native long _getShape(long address);

    /**
     * @param value WebIDL type: {@link PxShape}
     */
    public void setShape(PxShape value) {
        _setShape(address, value.getAddress());
    }
    private static native void _setShape(long address, long value);

}
