package physx.physics;

import physx.common.PxBase;
import physx.common.PxBounds3;

public class PxActor extends PxBase {

    protected PxActor() { }

    public static PxActor wrapPointer(long address) {
        return new PxActor(address);
    }
    
    protected PxActor(long address) {
        super(address);
    }

    // Functions

    /**
     * @return WebIDL type: {@link PxActorTypeEnum} [enum]
     */
    public int getType() {
        return _getType(address);
    }
    private static native int _getType(long address);

    /**
     * @return WebIDL type: {@link PxScene}
     */
    public PxScene getScene() {
        return PxScene.wrapPointer(_getScene(address));
    }
    private static native long _getScene(long address);

    /**
     * @param name WebIDL type: DOMString
     */
    public void setName(String name) {
        _setName(address, name);
    }
    private static native void _setName(long address, String name);

    /**
     * @return WebIDL type: DOMString [Const]
     */
    public String getName() {
        return _getName(address);
    }
    private static native String _getName(long address);

    /**
     * @return WebIDL type: {@link PxBounds3} [Value]
     */
    public PxBounds3 getWorldBounds() {
        return PxBounds3.wrapPointer(_getWorldBounds(address));
    }
    private static native long _getWorldBounds(long address);

    /**
     * @param inflation WebIDL type: float
     * @return WebIDL type: {@link PxBounds3} [Value]
     */
    public PxBounds3 getWorldBounds(float inflation) {
        return PxBounds3.wrapPointer(_getWorldBounds(address, inflation));
    }
    private static native long _getWorldBounds(long address, float inflation);

    /**
     * @param flags WebIDL type: {@link PxActorFlags} [Ref]
     */
    public void setActorFlags(PxActorFlags flags) {
        _setActorFlags(address, flags.getAddress());
    }
    private static native void _setActorFlags(long address, long flags);

    /**
     * @return WebIDL type: {@link PxActorFlags} [Value]
     */
    public PxActorFlags getActorFlags() {
        return PxActorFlags.wrapPointer(_getActorFlags(address));
    }
    private static native long _getActorFlags(long address);

    /**
     * @param dominanceGroup WebIDL type: octet
     */
    public void setDominanceGroup(byte dominanceGroup) {
        _setDominanceGroup(address, dominanceGroup);
    }
    private static native void _setDominanceGroup(long address, byte dominanceGroup);

    /**
     * @return WebIDL type: octet
     */
    public byte getDominanceGroup() {
        return _getDominanceGroup(address);
    }
    private static native byte _getDominanceGroup(long address);

    /**
     * @param inClient WebIDL type: octet
     */
    public void setOwnerClient(byte inClient) {
        _setOwnerClient(address, inClient);
    }
    private static native void _setOwnerClient(long address, byte inClient);

    /**
     * @return WebIDL type: octet
     */
    public byte getOwnerClient() {
        return _getOwnerClient(address);
    }
    private static native byte _getOwnerClient(long address);

}
