package physx.geomutils;


public class PxTriangleMeshGeometry extends PxGeometry {

    protected PxTriangleMeshGeometry() { }

    public static PxTriangleMeshGeometry wrapPointer(long address) {
        return new PxTriangleMeshGeometry(address);
    }
    
    protected PxTriangleMeshGeometry(long address) {
        super(address);
    }

    private static native int __sizeOf();
    public static final int SIZEOF = __sizeOf();
    public static final int ALIGNOF = 8;

    // Placed Constructors

    /**
     * @param address Pre-allocated memory, where the object is created.
     * @param mesh    WebIDL type: {@link PxTriangleMesh}
     * @return Stack allocated object of PxTriangleMeshGeometry
     */
    public static PxTriangleMeshGeometry createAt(long address, PxTriangleMesh mesh) {
        __placement_new_PxTriangleMeshGeometry(address, mesh.getAddress());
        PxTriangleMeshGeometry createdObj = wrapPointer(address);
        createdObj.isExternallyAllocated = true;
        return createdObj;
    }

    /**
     * @param <T>       Allocator class, e.g. LWJGL's MemoryStack.
     * @param allocator Object to use for allocation, e.g. an instance of LWJGL's MemoryStack.
     * @param allocate  Method to call on allocator to obtain the target address, e.g. MemoryStack::nmalloc.
     * @param mesh      WebIDL type: {@link PxTriangleMesh}
     * @return Stack allocated object of PxTriangleMeshGeometry
     */
    public static <T> PxTriangleMeshGeometry createAt(T allocator, Allocator<T> allocate, PxTriangleMesh mesh) {
        long address = allocate.on(allocator, ALIGNOF, SIZEOF); 
        __placement_new_PxTriangleMeshGeometry(address, mesh.getAddress());
        PxTriangleMeshGeometry createdObj = wrapPointer(address);
        createdObj.isExternallyAllocated = true;
        return createdObj;
    }

    private static native void __placement_new_PxTriangleMeshGeometry(long address, long mesh);

    /**
     * @param address Pre-allocated memory, where the object is created.
     * @param mesh    WebIDL type: {@link PxTriangleMesh}
     * @param scaling WebIDL type: {@link PxMeshScale} [Const, Ref]
     * @return Stack allocated object of PxTriangleMeshGeometry
     */
    public static PxTriangleMeshGeometry createAt(long address, PxTriangleMesh mesh, PxMeshScale scaling) {
        __placement_new_PxTriangleMeshGeometry(address, mesh.getAddress(), scaling.getAddress());
        PxTriangleMeshGeometry createdObj = wrapPointer(address);
        createdObj.isExternallyAllocated = true;
        return createdObj;
    }

    /**
     * @param <T>       Allocator class, e.g. LWJGL's MemoryStack.
     * @param allocator Object to use for allocation, e.g. an instance of LWJGL's MemoryStack.
     * @param allocate  Method to call on allocator to obtain the target address, e.g. MemoryStack::nmalloc.
     * @param mesh      WebIDL type: {@link PxTriangleMesh}
     * @param scaling   WebIDL type: {@link PxMeshScale} [Const, Ref]
     * @return Stack allocated object of PxTriangleMeshGeometry
     */
    public static <T> PxTriangleMeshGeometry createAt(T allocator, Allocator<T> allocate, PxTriangleMesh mesh, PxMeshScale scaling) {
        long address = allocate.on(allocator, ALIGNOF, SIZEOF); 
        __placement_new_PxTriangleMeshGeometry(address, mesh.getAddress(), scaling.getAddress());
        PxTriangleMeshGeometry createdObj = wrapPointer(address);
        createdObj.isExternallyAllocated = true;
        return createdObj;
    }

    private static native void __placement_new_PxTriangleMeshGeometry(long address, long mesh, long scaling);

    /**
     * @param address Pre-allocated memory, where the object is created.
     * @param mesh    WebIDL type: {@link PxTriangleMesh}
     * @param scaling WebIDL type: {@link PxMeshScale} [Const, Ref]
     * @param flags   WebIDL type: {@link PxMeshGeometryFlags} [Ref]
     * @return Stack allocated object of PxTriangleMeshGeometry
     */
    public static PxTriangleMeshGeometry createAt(long address, PxTriangleMesh mesh, PxMeshScale scaling, PxMeshGeometryFlags flags) {
        __placement_new_PxTriangleMeshGeometry(address, mesh.getAddress(), scaling.getAddress(), flags.getAddress());
        PxTriangleMeshGeometry createdObj = wrapPointer(address);
        createdObj.isExternallyAllocated = true;
        return createdObj;
    }

    /**
     * @param <T>       Allocator class, e.g. LWJGL's MemoryStack.
     * @param allocator Object to use for allocation, e.g. an instance of LWJGL's MemoryStack.
     * @param allocate  Method to call on allocator to obtain the target address, e.g. MemoryStack::nmalloc.
     * @param mesh      WebIDL type: {@link PxTriangleMesh}
     * @param scaling   WebIDL type: {@link PxMeshScale} [Const, Ref]
     * @param flags     WebIDL type: {@link PxMeshGeometryFlags} [Ref]
     * @return Stack allocated object of PxTriangleMeshGeometry
     */
    public static <T> PxTriangleMeshGeometry createAt(T allocator, Allocator<T> allocate, PxTriangleMesh mesh, PxMeshScale scaling, PxMeshGeometryFlags flags) {
        long address = allocate.on(allocator, ALIGNOF, SIZEOF); 
        __placement_new_PxTriangleMeshGeometry(address, mesh.getAddress(), scaling.getAddress(), flags.getAddress());
        PxTriangleMeshGeometry createdObj = wrapPointer(address);
        createdObj.isExternallyAllocated = true;
        return createdObj;
    }

    private static native void __placement_new_PxTriangleMeshGeometry(long address, long mesh, long scaling, long flags);

    // Constructors

    /**
     * @param mesh WebIDL type: {@link PxTriangleMesh}
     */
    public PxTriangleMeshGeometry(PxTriangleMesh mesh) {
        address = _PxTriangleMeshGeometry(mesh.getAddress());
    }
    private static native long _PxTriangleMeshGeometry(long mesh);

    /**
     * @param mesh    WebIDL type: {@link PxTriangleMesh}
     * @param scaling WebIDL type: {@link PxMeshScale} [Const, Ref]
     */
    public PxTriangleMeshGeometry(PxTriangleMesh mesh, PxMeshScale scaling) {
        address = _PxTriangleMeshGeometry(mesh.getAddress(), scaling.getAddress());
    }
    private static native long _PxTriangleMeshGeometry(long mesh, long scaling);

    /**
     * @param mesh    WebIDL type: {@link PxTriangleMesh}
     * @param scaling WebIDL type: {@link PxMeshScale} [Const, Ref]
     * @param flags   WebIDL type: {@link PxMeshGeometryFlags} [Ref]
     */
    public PxTriangleMeshGeometry(PxTriangleMesh mesh, PxMeshScale scaling, PxMeshGeometryFlags flags) {
        address = _PxTriangleMeshGeometry(mesh.getAddress(), scaling.getAddress(), flags.getAddress());
    }
    private static native long _PxTriangleMeshGeometry(long mesh, long scaling, long flags);

    // Destructor

    public void destroy() {
        if (address == 0L) {
            throw new IllegalStateException(this + " is already deleted");
        }
        if (isExternallyAllocated) {
            throw new IllegalStateException(this + " is externally allocated and cannot be manually destroyed");
        }
        _delete_native_instance(address);
        address = 0L;
    }
    private static native long _delete_native_instance(long address);

    // Functions

    /**
     * @return WebIDL type: boolean
     */
    public boolean isValid() {
        return _isValid(address);
    }
    private static native boolean _isValid(long address);

}
