package physx.geomutils;


public class PxPlaneGeometry extends PxGeometry {

    public static PxPlaneGeometry wrapPointer(long address) {
        return new PxPlaneGeometry(address);
    }
    
    protected PxPlaneGeometry(long address) {
        super(address);
    }

    private static native int __sizeOf();
    public static final int SIZEOF = __sizeOf();
    public static final int ALIGNOF = 8;

    // Placed Constructors

    /**
     * @param address Pre-allocated memory, where the object is created.
     * @return Stack allocated object of PxPlaneGeometry
     */
    public static PxPlaneGeometry createAt(long address) {
        __placement_new_PxPlaneGeometry(address);
        PxPlaneGeometry createdObj = wrapPointer(address);
        createdObj.isExternallyAllocated = true;
        return createdObj;
    }

    /**
     * @param <T>       Allocator class, e.g. LWJGL's MemoryStack.
     * @param allocator Object to use for allocation, e.g. an instance of LWJGL's MemoryStack.
     * @param allocate  Method to call on allocator to obtain the target address, e.g. MemoryStack::nmalloc.
     * @return Stack allocated object of PxPlaneGeometry
     */
    public static <T> PxPlaneGeometry createAt(T allocator, Allocator<T> allocate) {
        long address = allocate.on(allocator, ALIGNOF, SIZEOF); 
        __placement_new_PxPlaneGeometry(address);
        PxPlaneGeometry createdObj = wrapPointer(address);
        createdObj.isExternallyAllocated = true;
        return createdObj;
    }

    private static native void __placement_new_PxPlaneGeometry(long address);

    // Constructors

    public PxPlaneGeometry() {
        address = _PxPlaneGeometry();
    }
    private static native long _PxPlaneGeometry();

    // Destructor

    public void destroy() {
        if (address == 0L) {
            throw new IllegalStateException(this + " is already deleted");
        }
        if (isExternallyAllocated) {
            throw new IllegalStateException(this + " is externally allocated and cannot be manually destroyed");
        }
        _delete_native_instance(address);
        address = 0L;
    }
    private static native long _delete_native_instance(long address);

}
