package physx.geomutils;

import physx.NativeObject;
import physx.common.PxQuat;
import physx.common.PxVec3;

public class PxMeshScale extends NativeObject {

    public static PxMeshScale wrapPointer(long address) {
        return new PxMeshScale(address);
    }
    
    protected PxMeshScale(long address) {
        super(address);
    }

    // Constructors

    public PxMeshScale() {
        address = _PxMeshScale();
    }
    private static native long _PxMeshScale();

    /**
     * @param r WebIDL type: float
     */
    public PxMeshScale(float r) {
        address = _PxMeshScale(r);
    }
    private static native long _PxMeshScale(float r);

    /**
     * @param s WebIDL type: {@link PxVec3} [Const, Ref]
     * @param r WebIDL type: {@link PxQuat} [Const, Ref]
     */
    public PxMeshScale(PxVec3 s, PxQuat r) {
        address = _PxMeshScale(s.getAddress(), r.getAddress());
    }
    private static native long _PxMeshScale(long s, long r);

    // Destructor

    public void destroy() {
        if (address == 0L) {
            throw new IllegalStateException(this + " is already deleted");
        }
        if (isExternallyAllocated) {
            throw new IllegalStateException(this + " is externally allocated and cannot be manually destroyed");
        }
        _delete_native_instance(address);
        address = 0L;
    }
    private static native long _delete_native_instance(long address);

}
