package physx.geomutils;

import physx.NativeObject;

public class PxHullPolygon extends NativeObject {

    public static PxHullPolygon wrapPointer(long address) {
        return new PxHullPolygon(address);
    }
    
    protected PxHullPolygon(long address) {
        super(address);
    }

    // Constructors

    public PxHullPolygon() {
        address = _PxHullPolygon();
    }
    private static native long _PxHullPolygon();

    // Destructor

    public void destroy() {
        if (address == 0L) {
            throw new IllegalStateException(this + " is already deleted");
        }
        if (isExternallyAllocated) {
            throw new IllegalStateException(this + " is externally allocated and cannot be manually destroyed");
        }
        _delete_native_instance(address);
        address = 0L;
    }
    private static native long _delete_native_instance(long address);

    // Attributes

    /**
     * @param index Array index
     * @return WebIDL type: float
     */
    public float getMPlane(int index) {
        return _getMPlane(address, index);
    }
    private static native float _getMPlane(long address, int index);

    /**
     * @param index Array index
     * @param value WebIDL type: float
     */
    public void setMPlane(int index, float value) {
        _setMPlane(address, index, value);
    }
    private static native void _setMPlane(long address, int index, float value);

    /**
     * @return WebIDL type: short
     */
    public short getMNbVerts() {
        return _getMNbVerts(address);
    }
    private static native short _getMNbVerts(long address);

    /**
     * @param value WebIDL type: short
     */
    public void setMNbVerts(short value) {
        _setMNbVerts(address, value);
    }
    private static native void _setMNbVerts(long address, short value);

    /**
     * @return WebIDL type: short
     */
    public short getMIndexBase() {
        return _getMIndexBase(address);
    }
    private static native short _getMIndexBase(long address);

    /**
     * @param value WebIDL type: short
     */
    public void setMIndexBase(short value) {
        _setMIndexBase(address, value);
    }
    private static native void _setMIndexBase(long address, short value);

}
