package physx.geomutils;


public class PxBoxGeometry extends PxGeometry {

    protected PxBoxGeometry() { }

    public static PxBoxGeometry wrapPointer(long address) {
        return new PxBoxGeometry(address);
    }
    
    protected PxBoxGeometry(long address) {
        super(address);
    }

    private static native int __sizeOf();
    public static final int SIZEOF = __sizeOf();
    public static final int ALIGNOF = 8;

    // Placed Constructors

    /**
     * @param address Pre-allocated memory, where the object is created.
     * @param hx      WebIDL type: float
     * @param hy      WebIDL type: float
     * @param hz      WebIDL type: float
     * @return Stack allocated object of PxBoxGeometry
     */
    public static PxBoxGeometry createAt(long address, float hx, float hy, float hz) {
        __placement_new_PxBoxGeometry(address, hx, hy, hz);
        PxBoxGeometry createdObj = wrapPointer(address);
        createdObj.isExternallyAllocated = true;
        return createdObj;
    }

    /**
     * @param <T>       Allocator class, e.g. LWJGL's MemoryStack.
     * @param allocator Object to use for allocation, e.g. an instance of LWJGL's MemoryStack.
     * @param allocate  Method to call on allocator to obtain the target address, e.g. MemoryStack::nmalloc.
     * @param hx        WebIDL type: float
     * @param hy        WebIDL type: float
     * @param hz        WebIDL type: float
     * @return Stack allocated object of PxBoxGeometry
     */
    public static <T> PxBoxGeometry createAt(T allocator, Allocator<T> allocate, float hx, float hy, float hz) {
        long address = allocate.on(allocator, ALIGNOF, SIZEOF); 
        __placement_new_PxBoxGeometry(address, hx, hy, hz);
        PxBoxGeometry createdObj = wrapPointer(address);
        createdObj.isExternallyAllocated = true;
        return createdObj;
    }

    private static native void __placement_new_PxBoxGeometry(long address, float hx, float hy, float hz);

    // Constructors

    /**
     * @param hx WebIDL type: float
     * @param hy WebIDL type: float
     * @param hz WebIDL type: float
     */
    public PxBoxGeometry(float hx, float hy, float hz) {
        address = _PxBoxGeometry(hx, hy, hz);
    }
    private static native long _PxBoxGeometry(float hx, float hy, float hz);

    // Destructor

    public void destroy() {
        if (address == 0L) {
            throw new IllegalStateException(this + " is already deleted");
        }
        if (isExternallyAllocated) {
            throw new IllegalStateException(this + " is externally allocated and cannot be manually destroyed");
        }
        _delete_native_instance(address);
        address = 0L;
    }
    private static native long _delete_native_instance(long address);

}
