package physx.cooking;

import physx.NativeObject;

public class PxMidphaseDesc extends NativeObject {

    public static PxMidphaseDesc wrapPointer(long address) {
        return new PxMidphaseDesc(address);
    }
    
    protected PxMidphaseDesc(long address) {
        super(address);
    }

    // Constructors

    public PxMidphaseDesc() {
        address = _PxMidphaseDesc();
    }
    private static native long _PxMidphaseDesc();

    // Destructor

    public void destroy() {
        if (address == 0L) {
            throw new IllegalStateException(this + " is already deleted");
        }
        if (isExternallyAllocated) {
            throw new IllegalStateException(this + " is externally allocated and cannot be manually destroyed");
        }
        _delete_native_instance(address);
        address = 0L;
    }
    private static native long _delete_native_instance(long address);

    // Attributes

    /**
     * @return WebIDL type: {@link PxBVH33MidphaseDesc} [Value]
     */
    public PxBVH33MidphaseDesc getMBVH33Desc() {
        return PxBVH33MidphaseDesc.wrapPointer(_getMBVH33Desc(address));
    }
    private static native long _getMBVH33Desc(long address);

    /**
     * @param value WebIDL type: {@link PxBVH33MidphaseDesc} [Value]
     */
    public void setMBVH33Desc(PxBVH33MidphaseDesc value) {
        _setMBVH33Desc(address, value.getAddress());
    }
    private static native void _setMBVH33Desc(long address, long value);

    /**
     * @return WebIDL type: {@link PxBVH34MidphaseDesc} [Value]
     */
    public PxBVH34MidphaseDesc getMBVH34Desc() {
        return PxBVH34MidphaseDesc.wrapPointer(_getMBVH34Desc(address));
    }
    private static native long _getMBVH34Desc(long address);

    /**
     * @param value WebIDL type: {@link PxBVH34MidphaseDesc} [Value]
     */
    public void setMBVH34Desc(PxBVH34MidphaseDesc value) {
        _setMBVH34Desc(address, value.getAddress());
    }
    private static native void _setMBVH34Desc(long address, long value);

    // Functions

    /**
     * @return WebIDL type: {@link PxMeshMidPhaseEnum} [enum]
     */
    public int getType() {
        return _getType(address);
    }
    private static native int _getType(long address);

    /**
     * @param type WebIDL type: {@link PxMeshMidPhaseEnum} [enum]
     */
    public void setToDefault(int type) {
        _setToDefault(address, type);
    }
    private static native void _setToDefault(long address, int type);

    /**
     * @return WebIDL type: boolean
     */
    public boolean isValid() {
        return _isValid(address);
    }
    private static native boolean _isValid(long address);

}
