package physx.cooking;

import physx.NativeObject;
import physx.common.PxPhysicsInsertionCallback;
import physx.geomutils.PxConvexMesh;
import physx.geomutils.PxTriangleMesh;

public class PxCooking extends NativeObject {

    protected PxCooking() { }

    public static PxCooking wrapPointer(long address) {
        return new PxCooking(address);
    }
    
    protected PxCooking(long address) {
        super(address);
    }

    // Functions

    public void release() {
        _release(address);
    }
    private static native void _release(long address);

    /**
     * @param desc              WebIDL type: {@link PxConvexMeshDesc} [Const, Ref]
     * @param insertionCallback WebIDL type: {@link PxPhysicsInsertionCallback} [Ref]
     * @return WebIDL type: {@link PxConvexMesh}
     */
    public PxConvexMesh createConvexMesh(PxConvexMeshDesc desc, PxPhysicsInsertionCallback insertionCallback) {
        return PxConvexMesh.wrapPointer(_createConvexMesh(address, desc.getAddress(), insertionCallback.getAddress()));
    }
    private static native long _createConvexMesh(long address, long desc, long insertionCallback);

    /**
     * @param desc              WebIDL type: {@link PxTriangleMeshDesc} [Const, Ref]
     * @param insertionCallback WebIDL type: {@link PxPhysicsInsertionCallback} [Ref]
     * @return WebIDL type: {@link PxTriangleMesh}
     */
    public PxTriangleMesh createTriangleMesh(PxTriangleMeshDesc desc, PxPhysicsInsertionCallback insertionCallback) {
        return PxTriangleMesh.wrapPointer(_createTriangleMesh(address, desc.getAddress(), insertionCallback.getAddress()));
    }
    private static native long _createTriangleMesh(long address, long desc, long insertionCallback);

}
