package physx.common;

import physx.NativeObject;

public class PxVec3 extends NativeObject {

    public static PxVec3 wrapPointer(long address) {
        return new PxVec3(address);
    }
    
    protected PxVec3(long address) {
        super(address);
    }

    private static native int __sizeOf();
    public static final int SIZEOF = __sizeOf();
    public static final int ALIGNOF = 8;

    // Placed Constructors

    /**
     * @param address Pre-allocated memory, where the object is created.
     * @return Stack allocated object of PxVec3
     */
    public static PxVec3 createAt(long address) {
        __placement_new_PxVec3(address);
        PxVec3 createdObj = wrapPointer(address);
        createdObj.isExternallyAllocated = true;
        return createdObj;
    }

    /**
     * @param <T>       Allocator class, e.g. LWJGL's MemoryStack.
     * @param allocator Object to use for allocation, e.g. an instance of LWJGL's MemoryStack.
     * @param allocate  Method to call on allocator to obtain the target address, e.g. MemoryStack::nmalloc.
     * @return Stack allocated object of PxVec3
     */
    public static <T> PxVec3 createAt(T allocator, Allocator<T> allocate) {
        long address = allocate.on(allocator, ALIGNOF, SIZEOF); 
        __placement_new_PxVec3(address);
        PxVec3 createdObj = wrapPointer(address);
        createdObj.isExternallyAllocated = true;
        return createdObj;
    }

    private static native void __placement_new_PxVec3(long address);

    /**
     * @param address Pre-allocated memory, where the object is created.
     * @param x       WebIDL type: float
     * @param y       WebIDL type: float
     * @param z       WebIDL type: float
     * @return Stack allocated object of PxVec3
     */
    public static PxVec3 createAt(long address, float x, float y, float z) {
        __placement_new_PxVec3(address, x, y, z);
        PxVec3 createdObj = wrapPointer(address);
        createdObj.isExternallyAllocated = true;
        return createdObj;
    }

    /**
     * @param <T>       Allocator class, e.g. LWJGL's MemoryStack.
     * @param allocator Object to use for allocation, e.g. an instance of LWJGL's MemoryStack.
     * @param allocate  Method to call on allocator to obtain the target address, e.g. MemoryStack::nmalloc.
     * @param x         WebIDL type: float
     * @param y         WebIDL type: float
     * @param z         WebIDL type: float
     * @return Stack allocated object of PxVec3
     */
    public static <T> PxVec3 createAt(T allocator, Allocator<T> allocate, float x, float y, float z) {
        long address = allocate.on(allocator, ALIGNOF, SIZEOF); 
        __placement_new_PxVec3(address, x, y, z);
        PxVec3 createdObj = wrapPointer(address);
        createdObj.isExternallyAllocated = true;
        return createdObj;
    }

    private static native void __placement_new_PxVec3(long address, float x, float y, float z);

    // Constructors

    public PxVec3() {
        address = _PxVec3();
    }
    private static native long _PxVec3();

    /**
     * @param x WebIDL type: float
     * @param y WebIDL type: float
     * @param z WebIDL type: float
     */
    public PxVec3(float x, float y, float z) {
        address = _PxVec3(x, y, z);
    }
    private static native long _PxVec3(float x, float y, float z);

    // Destructor

    public void destroy() {
        if (address == 0L) {
            throw new IllegalStateException(this + " is already deleted");
        }
        if (isExternallyAllocated) {
            throw new IllegalStateException(this + " is externally allocated and cannot be manually destroyed");
        }
        _delete_native_instance(address);
        address = 0L;
    }
    private static native long _delete_native_instance(long address);

    // Attributes

    /**
     * @return WebIDL type: float
     */
    public float getX() {
        return _getX(address);
    }
    private static native float _getX(long address);

    /**
     * @param value WebIDL type: float
     */
    public void setX(float value) {
        _setX(address, value);
    }
    private static native void _setX(long address, float value);

    /**
     * @return WebIDL type: float
     */
    public float getY() {
        return _getY(address);
    }
    private static native float _getY(long address);

    /**
     * @param value WebIDL type: float
     */
    public void setY(float value) {
        _setY(address, value);
    }
    private static native void _setY(long address, float value);

    /**
     * @return WebIDL type: float
     */
    public float getZ() {
        return _getZ(address);
    }
    private static native float _getZ(long address);

    /**
     * @param value WebIDL type: float
     */
    public void setZ(float value) {
        _setZ(address, value);
    }
    private static native void _setZ(long address, float value);

}
