package physx.common;

import physx.NativeObject;

public class PxErrorCallback extends NativeObject {

    protected PxErrorCallback() { }

    public static PxErrorCallback wrapPointer(long address) {
        return new PxErrorCallback(address);
    }
    
    protected PxErrorCallback(long address) {
        super(address);
    }

    // Destructor

    public void destroy() {
        if (address == 0L) {
            throw new IllegalStateException(this + " is already deleted");
        }
        if (isExternallyAllocated) {
            throw new IllegalStateException(this + " is externally allocated and cannot be manually destroyed");
        }
        _delete_native_instance(address);
        address = 0L;
    }
    private static native long _delete_native_instance(long address);

    // Functions

    /**
     * @param code    WebIDL type: {@link PxErrorCodeEnum} [enum]
     * @param message WebIDL type: DOMString
     * @param file    WebIDL type: DOMString
     * @param line    WebIDL type: long
     */
    public void reportError(int code, String message, String file, int line) {
        _reportError(address, code, message, file, line);
    }
    private static native void _reportError(long address, int code, String message, String file, int line);

}
