package physx.common;


public class PxDefaultErrorCallback extends PxErrorCallback {

    public static PxDefaultErrorCallback wrapPointer(long address) {
        return new PxDefaultErrorCallback(address);
    }
    
    protected PxDefaultErrorCallback(long address) {
        super(address);
    }

    // Constructors

    public PxDefaultErrorCallback() {
        address = _PxDefaultErrorCallback();
    }
    private static native long _PxDefaultErrorCallback();

    // Destructor

    public void destroy() {
        if (address == 0L) {
            throw new IllegalStateException(this + " is already deleted");
        }
        if (isExternallyAllocated) {
            throw new IllegalStateException(this + " is externally allocated and cannot be manually destroyed");
        }
        _delete_native_instance(address);
        address = 0L;
    }
    private static native long _delete_native_instance(long address);

}
