package physx.common;

import physx.NativeObject;

public class PxBaseTask extends NativeObject {

    protected PxBaseTask() { }

    public static PxBaseTask wrapPointer(long address) {
        return new PxBaseTask(address);
    }
    
    protected PxBaseTask(long address) {
        super(address);
    }

    // Destructor

    public void destroy() {
        if (address == 0L) {
            throw new IllegalStateException(this + " is already deleted");
        }
        if (isExternallyAllocated) {
            throw new IllegalStateException(this + " is externally allocated and cannot be manually destroyed");
        }
        _delete_native_instance(address);
        address = 0L;
    }
    private static native long _delete_native_instance(long address);

}
