package physx.common;


public class JavaErrorCallback extends PxErrorCallback {

    public static JavaErrorCallback wrapPointer(long address) {
        return new JavaErrorCallback(address);
    }
    
    protected JavaErrorCallback(long address) {
        super(address);
    }

    protected JavaErrorCallback() {
        address = _JavaErrorCallback();
    }
    private native long _JavaErrorCallback();
    
    // Destructor

    public void destroy() {
        if (address == 0L) {
            throw new IllegalStateException(this + " is already deleted");
        }
        if (isExternallyAllocated) {
            throw new IllegalStateException(this + " is externally allocated and cannot be manually destroyed");
        }
        _delete_native_instance(address);
        address = 0L;
    }
    private static native long _delete_native_instance(long address);

    // Functions

    /*
     * Called from native code
     */
    private void _reportError(int code, String message, String file, int line) {
        reportError(code, message, file, line);
    }

    /**
     * @param code    WebIDL type: {@link PxErrorCodeEnum} [enum]
     * @param message WebIDL type: DOMString
     * @param file    WebIDL type: DOMString
     * @param line    WebIDL type: long
     */
    public void reportError(int code, String message, String file, int line) { }

}
