package physx;

import physx.common.PxErrorCallback;
import physx.common.PxFoundation;
import physx.common.PxTolerancesScale;
import physx.common.PxTransform;
import physx.common.PxVec3;
import physx.cooking.PxCooking;
import physx.cooking.PxCookingParams;
import physx.extensions.PxDefaultAllocator;
import physx.extensions.PxDefaultCpuDispatcher;
import physx.extensions.PxRevoluteJoint;
import physx.physics.PxBatchQueryPostFilterShader;
import physx.physics.PxBatchQueryPreFilterShader;
import physx.physics.PxContactPair;
import physx.physics.PxPhysics;
import physx.physics.PxRigidActor;
import physx.physics.PxSimulationFilterShader;
import physx.physics.PxTriggerPair;
import physx.support.PxRealPtr;
import physx.support.PxU16Ptr;
import physx.support.PxU32Ptr;
import physx.support.PxU8Ptr;

public class PxTopLevelFunctions extends NativeObject {

    protected PxTopLevelFunctions() { }

    public static PxTopLevelFunctions wrapPointer(long address) {
        return new PxTopLevelFunctions(address);
    }
    
    protected PxTopLevelFunctions(long address) {
        super(address);
    }

    // Destructor

    public void destroy() {
        if (address == 0L) {
            throw new IllegalStateException(this + " is already deleted");
        }
        if (isExternallyAllocated) {
            throw new IllegalStateException(this + " is externally allocated and cannot be manually destroyed");
        }
        _delete_native_instance(address);
        address = 0L;
    }
    private static native long _delete_native_instance(long address);

    // Attributes

    /**
     * @return WebIDL type: unsigned long
     */
    public static int getPHYSICS_VERSION() {
        return _getPHYSICS_VERSION();
    }
    private static native int _getPHYSICS_VERSION();

    // Functions

    /**
     * @return WebIDL type: {@link PxSimulationFilterShader} [Value]
     */
    public static PxSimulationFilterShader DefaultFilterShader() {
        return PxSimulationFilterShader.wrapPointer(_DefaultFilterShader());
    }
    private static native long _DefaultFilterShader();

    /**
     * @return WebIDL type: {@link PxBatchQueryPreFilterShader} [Value]
     */
    public static PxBatchQueryPreFilterShader DefaultWheelSceneQueryPreFilterBlocking() {
        return PxBatchQueryPreFilterShader.wrapPointer(_DefaultWheelSceneQueryPreFilterBlocking());
    }
    private static native long _DefaultWheelSceneQueryPreFilterBlocking();

    /**
     * @return WebIDL type: {@link PxBatchQueryPostFilterShader} [Value]
     */
    public static PxBatchQueryPostFilterShader DefaultWheelSceneQueryPostFilterBlocking() {
        return PxBatchQueryPostFilterShader.wrapPointer(_DefaultWheelSceneQueryPostFilterBlocking());
    }
    private static native long _DefaultWheelSceneQueryPostFilterBlocking();

    /**
     * @param version    WebIDL type: unsigned long
     * @param foundation WebIDL type: {@link PxFoundation} [Ref]
     * @param scale      WebIDL type: {@link PxCookingParams} [Const, Ref]
     * @return WebIDL type: {@link PxCooking}
     */
    public static PxCooking CreateCooking(int version, PxFoundation foundation, PxCookingParams scale) {
        return PxCooking.wrapPointer(_CreateCooking(version, foundation.getAddress(), scale.getAddress()));
    }
    private static native long _CreateCooking(int version, long foundation, long scale);

    /**
     * @param version       WebIDL type: unsigned long
     * @param allocator     WebIDL type: {@link PxDefaultAllocator} [Ref]
     * @param errorCallback WebIDL type: {@link PxErrorCallback} [Ref]
     * @return WebIDL type: {@link PxFoundation}
     */
    public static PxFoundation CreateFoundation(int version, PxDefaultAllocator allocator, PxErrorCallback errorCallback) {
        return PxFoundation.wrapPointer(_CreateFoundation(version, allocator.getAddress(), errorCallback.getAddress()));
    }
    private static native long _CreateFoundation(int version, long allocator, long errorCallback);

    /**
     * @param version    WebIDL type: unsigned long
     * @param foundation WebIDL type: {@link PxFoundation} [Ref]
     * @param params     WebIDL type: {@link PxTolerancesScale} [Const, Ref]
     * @return WebIDL type: {@link PxPhysics}
     */
    public static PxPhysics CreatePhysics(int version, PxFoundation foundation, PxTolerancesScale params) {
        return PxPhysics.wrapPointer(_CreatePhysics(version, foundation.getAddress(), params.getAddress()));
    }
    private static native long _CreatePhysics(int version, long foundation, long params);

    /**
     * @param numThreads WebIDL type: unsigned long
     * @return WebIDL type: {@link PxDefaultCpuDispatcher}
     */
    public static PxDefaultCpuDispatcher DefaultCpuDispatcherCreate(int numThreads) {
        return PxDefaultCpuDispatcher.wrapPointer(_DefaultCpuDispatcherCreate(numThreads));
    }
    private static native long _DefaultCpuDispatcherCreate(int numThreads);

    /**
     * @param physics WebIDL type: {@link PxPhysics} [Ref]
     * @return WebIDL type: boolean
     */
    public static boolean InitExtensions(PxPhysics physics) {
        return _InitExtensions(physics.getAddress());
    }
    private static native boolean _InitExtensions(long physics);

    /**
     * @param physics     WebIDL type: {@link PxPhysics} [Ref]
     * @param actor0      WebIDL type: {@link PxRigidActor}
     * @param localFrame0 WebIDL type: {@link PxTransform} [Ref]
     * @param actor1      WebIDL type: {@link PxRigidActor}
     * @param localFrame1 WebIDL type: {@link PxTransform} [Ref]
     * @return WebIDL type: {@link PxRevoluteJoint}
     */
    public static PxRevoluteJoint RevoluteJointCreate(PxPhysics physics, PxRigidActor actor0, PxTransform localFrame0, PxRigidActor actor1, PxTransform localFrame1) {
        return PxRevoluteJoint.wrapPointer(_RevoluteJointCreate(physics.getAddress(), actor0.getAddress(), localFrame0.getAddress(), actor1.getAddress(), localFrame1.getAddress()));
    }
    private static native long _RevoluteJointCreate(long physics, long actor0, long localFrame0, long actor1, long localFrame1);

    /**
     * @param base  WebIDL type: {@link PxU8Ptr} [Ref]
     * @param index WebIDL type: long
     * @return WebIDL type: octet
     */
    public static byte getU8At(PxU8Ptr base, int index) {
        return _getU8At(base.getAddress(), index);
    }
    private static native byte _getU8At(long base, int index);

    /**
     * @param base  WebIDL type: {@link PxU16Ptr} [Ref]
     * @param index WebIDL type: long
     * @return WebIDL type: unsigned short
     */
    public static short getU16At(PxU16Ptr base, int index) {
        return _getU16At(base.getAddress(), index);
    }
    private static native short _getU16At(long base, int index);

    /**
     * @param base  WebIDL type: {@link PxU32Ptr} [Ref]
     * @param index WebIDL type: long
     * @return WebIDL type: unsigned long
     */
    public static int getU32At(PxU32Ptr base, int index) {
        return _getU32At(base.getAddress(), index);
    }
    private static native int _getU32At(long base, int index);

    /**
     * @param base  WebIDL type: {@link PxRealPtr} [Ref]
     * @param index WebIDL type: long
     * @return WebIDL type: float
     */
    public static float getRealAt(PxRealPtr base, int index) {
        return _getRealAt(base.getAddress(), index);
    }
    private static native float _getRealAt(long base, int index);

    /**
     * @param base  WebIDL type: {@link PxContactPair}
     * @param index WebIDL type: long
     * @return WebIDL type: {@link PxContactPair}
     */
    public static PxContactPair getContactPairAt(PxContactPair base, int index) {
        return PxContactPair.wrapPointer(_getContactPairAt(base.getAddress(), index));
    }
    private static native long _getContactPairAt(long base, int index);

    /**
     * @param base  WebIDL type: {@link PxTriggerPair}
     * @param index WebIDL type: long
     * @return WebIDL type: {@link PxTriggerPair}
     */
    public static PxTriggerPair getTriggerPairAt(PxTriggerPair base, int index) {
        return PxTriggerPair.wrapPointer(_getTriggerPairAt(base.getAddress(), index));
    }
    private static native long _getTriggerPairAt(long base, int index);

    /**
     * @param base  WebIDL type: {@link PxVec3}
     * @param index WebIDL type: long
     * @return WebIDL type: {@link PxVec3}
     */
    public static PxVec3 getVec3At(PxVec3 base, int index) {
        return PxVec3.wrapPointer(_getVec3At(base.getAddress(), index));
    }
    private static native long _getVec3At(long base, int index);

}
