package physx.vehicle;

import physx.NativeObject;

public class PxVehicleWheelsSimFlags extends NativeObject {

    protected PxVehicleWheelsSimFlags() { }

    public static PxVehicleWheelsSimFlags wrapPointer(long address) {
        return new PxVehicleWheelsSimFlags(address);
    }
    
    protected PxVehicleWheelsSimFlags(long address) {
        super(address);
    }

    // Constructors

    /**
     * @param flags unsigned long
     */
    public PxVehicleWheelsSimFlags(int flags) {
        address = _PxVehicleWheelsSimFlags(flags);
    }
    private static native long _PxVehicleWheelsSimFlags(int flags);

    // Destructor

    public void destroy() {
        if (address == 0L) {
            throw new IllegalStateException(this + " is already deleted");
        }
        if (isStackAllocated) {
            throw new IllegalStateException(this + " is stack allocated and cannot be deleted");
        }
        _delete_native_instance(address);
        address = 0L;
    }
    private static native long _delete_native_instance(long address);

    // Functions

    /**
     * @param flag {@link PxVehicleWheelsSimFlagEnum} [enum]
     * @return boolean
     */
    public boolean isSet(int flag) {
        return _isSet(address, flag);
    }
    private static native boolean _isSet(long address, int flag);

    /**
     * @param flag {@link PxVehicleWheelsSimFlagEnum} [enum]
     */
    public void set(int flag) {
        _set(address, flag);
    }
    private static native void _set(long address, int flag);

    /**
     * @param flag {@link PxVehicleWheelsSimFlagEnum} [enum]
     */
    public void clear(int flag) {
        _clear(address, flag);
    }
    private static native void _clear(long address, int flag);

}
