package physx.vehicle;

import physx.NativeObject;
import physx.common.PxVec3;
import physx.physics.PxFilterData;

public class PxVehicleWheelsSimData extends NativeObject {

    protected PxVehicleWheelsSimData() { }

    public static PxVehicleWheelsSimData wrapPointer(long address) {
        return new PxVehicleWheelsSimData(address);
    }
    
    protected PxVehicleWheelsSimData(long address) {
        super(address);
    }

    // Destructor

    public void destroy() {
        if (address == 0L) {
            throw new IllegalStateException(this + " is already deleted");
        }
        if (isStackAllocated) {
            throw new IllegalStateException(this + " is stack allocated and cannot be deleted");
        }
        _delete_native_instance(address);
        address = 0L;
    }
    private static native long _delete_native_instance(long address);

    // Functions

    /**
     * @param nbWheels unsigned long
     * @return {@link PxVehicleWheelsSimData}
     */
    public static PxVehicleWheelsSimData allocate(int nbWheels) {
        return PxVehicleWheelsSimData.wrapPointer(_allocate(nbWheels));
    }
    private static native long _allocate(int nbWheels);

    /**
     * @param chassisMass float
     */
    public void setChassisMass(float chassisMass) {
        _setChassisMass(address, chassisMass);
    }
    private static native void _setChassisMass(long address, float chassisMass);

    public void free() {
        _free(address);
    }
    private static native void _free(long address);

    /**
     * @param src      {@link PxVehicleWheelsSimData} [Const, Ref]
     * @param srcWheel unsigned long
     * @param trgWheel unsigned long
     */
    public void copy(PxVehicleWheelsSimData src, int srcWheel, int trgWheel) {
        _copy(address, src.getAddress(), srcWheel, trgWheel);
    }
    private static native void _copy(long address, long src, int srcWheel, int trgWheel);

    /**
     * @return unsigned long
     */
    public int getNbWheels() {
        return _getNbWheels(address);
    }
    private static native int _getNbWheels(long address);

    /**
     * @param id unsigned long
     * @return {@link PxVehicleSuspensionData} [Const, Ref]
     */
    public PxVehicleSuspensionData getSuspensionData(int id) {
        return PxVehicleSuspensionData.wrapPointer(_getSuspensionData(address, id));
    }
    private static native long _getSuspensionData(long address, int id);

    /**
     * @param id unsigned long
     * @return {@link PxVehicleWheelData} [Const, Ref]
     */
    public PxVehicleWheelData getWheelData(int id) {
        return PxVehicleWheelData.wrapPointer(_getWheelData(address, id));
    }
    private static native long _getWheelData(long address, int id);

    /**
     * @param id unsigned long
     * @return {@link PxVehicleTireData} [Const, Ref]
     */
    public PxVehicleTireData getTireData(int id) {
        return PxVehicleTireData.wrapPointer(_getTireData(address, id));
    }
    private static native long _getTireData(long address, int id);

    /**
     * @param id unsigned long
     * @return {@link PxVec3} [Const, Ref]
     */
    public PxVec3 getSuspTravelDirection(int id) {
        return PxVec3.wrapPointer(_getSuspTravelDirection(address, id));
    }
    private static native long _getSuspTravelDirection(long address, int id);

    /**
     * @param id unsigned long
     * @return {@link PxVec3} [Const, Ref]
     */
    public PxVec3 getSuspForceAppPointOffset(int id) {
        return PxVec3.wrapPointer(_getSuspForceAppPointOffset(address, id));
    }
    private static native long _getSuspForceAppPointOffset(long address, int id);

    /**
     * @param id unsigned long
     * @return {@link PxVec3} [Const, Ref]
     */
    public PxVec3 getTireForceAppPointOffset(int id) {
        return PxVec3.wrapPointer(_getTireForceAppPointOffset(address, id));
    }
    private static native long _getTireForceAppPointOffset(long address, int id);

    /**
     * @param id unsigned long
     * @return {@link PxVec3} [Const, Ref]
     */
    public PxVec3 getWheelCentreOffset(int id) {
        return PxVec3.wrapPointer(_getWheelCentreOffset(address, id));
    }
    private static native long _getWheelCentreOffset(long address, int id);

    /**
     * @param wheelId unsigned long
     * @return long
     */
    public int getWheelShapeMapping(int wheelId) {
        return _getWheelShapeMapping(address, wheelId);
    }
    private static native int _getWheelShapeMapping(long address, int wheelId);

    /**
     * @param suspId unsigned long
     * @return {@link PxFilterData} [Const, Ref]
     */
    public PxFilterData getSceneQueryFilterData(int suspId) {
        return PxFilterData.wrapPointer(_getSceneQueryFilterData(address, suspId));
    }
    private static native long _getSceneQueryFilterData(long address, int suspId);

    /**
     * @return unsigned long
     */
    public int getNbAntiRollBars() {
        return _getNbAntiRollBars(address);
    }
    private static native int _getNbAntiRollBars(long address);

    /**
     * @param antiRollId unsigned long
     * @return {@link PxVehicleAntiRollBarData} [Const, Ref]
     */
    public PxVehicleAntiRollBarData getAntiRollBarData(int antiRollId) {
        return PxVehicleAntiRollBarData.wrapPointer(_getAntiRollBarData(address, antiRollId));
    }
    private static native long _getAntiRollBarData(long address, int antiRollId);

    /**
     * @return {@link PxVehicleTireLoadFilterData} [Const, Ref]
     */
    public PxVehicleTireLoadFilterData getTireLoadFilterData() {
        return PxVehicleTireLoadFilterData.wrapPointer(_getTireLoadFilterData(address));
    }
    private static native long _getTireLoadFilterData(long address);

    /**
     * @param id   unsigned long
     * @param susp {@link PxVehicleSuspensionData} [Const, Ref]
     */
    public void setSuspensionData(int id, PxVehicleSuspensionData susp) {
        _setSuspensionData(address, id, susp.getAddress());
    }
    private static native void _setSuspensionData(long address, int id, long susp);

    /**
     * @param id    unsigned long
     * @param wheel {@link PxVehicleWheelData} [Const, Ref]
     */
    public void setWheelData(int id, PxVehicleWheelData wheel) {
        _setWheelData(address, id, wheel.getAddress());
    }
    private static native void _setWheelData(long address, int id, long wheel);

    /**
     * @param id   unsigned long
     * @param tire {@link PxVehicleTireData} [Const, Ref]
     */
    public void setTireData(int id, PxVehicleTireData tire) {
        _setTireData(address, id, tire.getAddress());
    }
    private static native void _setTireData(long address, int id, long tire);

    /**
     * @param id  unsigned long
     * @param dir {@link PxVec3} [Const, Ref]
     */
    public void setSuspTravelDirection(int id, PxVec3 dir) {
        _setSuspTravelDirection(address, id, dir.getAddress());
    }
    private static native void _setSuspTravelDirection(long address, int id, long dir);

    /**
     * @param id     unsigned long
     * @param offset {@link PxVec3} [Const, Ref]
     */
    public void setSuspForceAppPointOffset(int id, PxVec3 offset) {
        _setSuspForceAppPointOffset(address, id, offset.getAddress());
    }
    private static native void _setSuspForceAppPointOffset(long address, int id, long offset);

    /**
     * @param id     unsigned long
     * @param offset {@link PxVec3} [Const, Ref]
     */
    public void setTireForceAppPointOffset(int id, PxVec3 offset) {
        _setTireForceAppPointOffset(address, id, offset.getAddress());
    }
    private static native void _setTireForceAppPointOffset(long address, int id, long offset);

    /**
     * @param id     unsigned long
     * @param offset {@link PxVec3} [Const, Ref]
     */
    public void setWheelCentreOffset(int id, PxVec3 offset) {
        _setWheelCentreOffset(address, id, offset.getAddress());
    }
    private static native void _setWheelCentreOffset(long address, int id, long offset);

    /**
     * @param wheelId unsigned long
     * @param shapeId long
     */
    public void setWheelShapeMapping(int wheelId, int shapeId) {
        _setWheelShapeMapping(address, wheelId, shapeId);
    }
    private static native void _setWheelShapeMapping(long address, int wheelId, int shapeId);

    /**
     * @param suspId       unsigned long
     * @param sqFilterData {@link PxFilterData} [Const, Ref]
     */
    public void setSceneQueryFilterData(int suspId, PxFilterData sqFilterData) {
        _setSceneQueryFilterData(address, suspId, sqFilterData.getAddress());
    }
    private static native void _setSceneQueryFilterData(long address, int suspId, long sqFilterData);

    /**
     * @param tireLoadFilter {@link PxVehicleTireLoadFilterData} [Const, Ref]
     */
    public void setTireLoadFilterData(PxVehicleTireLoadFilterData tireLoadFilter) {
        _setTireLoadFilterData(address, tireLoadFilter.getAddress());
    }
    private static native void _setTireLoadFilterData(long address, long tireLoadFilter);

    /**
     * @param antiRoll {@link PxVehicleAntiRollBarData} [Const, Ref]
     * @return unsigned long
     */
    public int addAntiRollBarData(PxVehicleAntiRollBarData antiRoll) {
        return _addAntiRollBarData(address, antiRoll.getAddress());
    }
    private static native int _addAntiRollBarData(long address, long antiRoll);

    /**
     * @param wheel unsigned long
     */
    public void disableWheel(int wheel) {
        _disableWheel(address, wheel);
    }
    private static native void _disableWheel(long address, int wheel);

    /**
     * @param wheel unsigned long
     */
    public void enableWheel(int wheel) {
        _enableWheel(address, wheel);
    }
    private static native void _enableWheel(long address, int wheel);

    /**
     * @param wheel unsigned long
     * @return boolean
     */
    public boolean getIsWheelDisabled(int wheel) {
        return _getIsWheelDisabled(address, wheel);
    }
    private static native boolean _getIsWheelDisabled(long address, int wheel);

    /**
     * @param thresholdLongitudinalSpeed   float
     * @param lowForwardSpeedSubStepCount  unsigned long
     * @param highForwardSpeedSubStepCount unsigned long
     */
    public void setSubStepCount(float thresholdLongitudinalSpeed, int lowForwardSpeedSubStepCount, int highForwardSpeedSubStepCount) {
        _setSubStepCount(address, thresholdLongitudinalSpeed, lowForwardSpeedSubStepCount, highForwardSpeedSubStepCount);
    }
    private static native void _setSubStepCount(long address, float thresholdLongitudinalSpeed, int lowForwardSpeedSubStepCount, int highForwardSpeedSubStepCount);

    /**
     * @param minLongSlipDenominator float
     */
    public void setMinLongSlipDenominator(float minLongSlipDenominator) {
        _setMinLongSlipDenominator(address, minLongSlipDenominator);
    }
    private static native void _setMinLongSlipDenominator(long address, float minLongSlipDenominator);

    /**
     * @param flags {@link PxVehicleWheelsSimFlags} [Ref]
     */
    public void setFlags(PxVehicleWheelsSimFlags flags) {
        _setFlags(address, flags.getAddress());
    }
    private static native void _setFlags(long address, long flags);

    /**
     * @return {@link PxVehicleWheelsSimFlags} [Value]
     */
    public PxVehicleWheelsSimFlags getFlags() {
        return PxVehicleWheelsSimFlags.wrapPointer(_getFlags(address));
    }
    private static native long _getFlags(long address);

    /**
     * @return unsigned long
     */
    public int getNbWheels4() {
        return _getNbWheels4(address);
    }
    private static native int _getNbWheels4(long address);

    /**
     * @return unsigned long
     */
    public int getNbSuspensionData() {
        return _getNbSuspensionData(address);
    }
    private static native int _getNbSuspensionData(long address);

    /**
     * @return unsigned long
     */
    public int getNbWheelData() {
        return _getNbWheelData(address);
    }
    private static native int _getNbWheelData(long address);

    /**
     * @return unsigned long
     */
    public int getNbSuspTravelDirection() {
        return _getNbSuspTravelDirection(address);
    }
    private static native int _getNbSuspTravelDirection(long address);

    /**
     * @return unsigned long
     */
    public int getNbTireData() {
        return _getNbTireData(address);
    }
    private static native int _getNbTireData(long address);

    /**
     * @return unsigned long
     */
    public int getNbSuspForceAppPointOffset() {
        return _getNbSuspForceAppPointOffset(address);
    }
    private static native int _getNbSuspForceAppPointOffset(long address);

    /**
     * @return unsigned long
     */
    public int getNbTireForceAppPointOffset() {
        return _getNbTireForceAppPointOffset(address);
    }
    private static native int _getNbTireForceAppPointOffset(long address);

    /**
     * @return unsigned long
     */
    public int getNbWheelCentreOffset() {
        return _getNbWheelCentreOffset(address);
    }
    private static native int _getNbWheelCentreOffset(long address);

    /**
     * @return unsigned long
     */
    public int getNbWheelShapeMapping() {
        return _getNbWheelShapeMapping(address);
    }
    private static native int _getNbWheelShapeMapping(long address);

    /**
     * @return unsigned long
     */
    public int getNbSceneQueryFilterData() {
        return _getNbSceneQueryFilterData(address);
    }
    private static native int _getNbSceneQueryFilterData(long address);

    /**
     * @return float
     */
    public float getMinLongSlipDenominator() {
        return _getMinLongSlipDenominator(address);
    }
    private static native float _getMinLongSlipDenominator(long address);

    /**
     * @param f float
     */
    public void setThresholdLongSpeed(float f) {
        _setThresholdLongSpeed(address, f);
    }
    private static native void _setThresholdLongSpeed(long address, float f);

    /**
     * @return float
     */
    public float getThresholdLongSpeed() {
        return _getThresholdLongSpeed(address);
    }
    private static native float _getThresholdLongSpeed(long address);

    /**
     * @param f unsigned long
     */
    public void setLowForwardSpeedSubStepCount(int f) {
        _setLowForwardSpeedSubStepCount(address, f);
    }
    private static native void _setLowForwardSpeedSubStepCount(long address, int f);

    /**
     * @return unsigned long
     */
    public int getLowForwardSpeedSubStepCount() {
        return _getLowForwardSpeedSubStepCount(address);
    }
    private static native int _getLowForwardSpeedSubStepCount(long address);

    /**
     * @param f unsigned long
     */
    public void setHighForwardSpeedSubStepCount(int f) {
        _setHighForwardSpeedSubStepCount(address, f);
    }
    private static native void _setHighForwardSpeedSubStepCount(long address, int f);

    /**
     * @return unsigned long
     */
    public int getHighForwardSpeedSubStepCount() {
        return _getHighForwardSpeedSubStepCount(address);
    }
    private static native int _getHighForwardSpeedSubStepCount(long address);

    /**
     * @param wheel unsigned long
     * @param state boolean
     */
    public void setWheelEnabledState(int wheel, boolean state) {
        _setWheelEnabledState(address, wheel, state);
    }
    private static native void _setWheelEnabledState(long address, int wheel, boolean state);

    /**
     * @param wheel unsigned long
     * @return boolean
     */
    public boolean getWheelEnabledState(int wheel) {
        return _getWheelEnabledState(address, wheel);
    }
    private static native boolean _getWheelEnabledState(long address, int wheel);

    /**
     * @return unsigned long
     */
    public int getNbWheelEnabledState() {
        return _getNbWheelEnabledState(address);
    }
    private static native int _getNbWheelEnabledState(long address);

    /**
     * @return unsigned long
     */
    public int getNbAntiRollBars4() {
        return _getNbAntiRollBars4(address);
    }
    private static native int _getNbAntiRollBars4(long address);

    /**
     * @return unsigned long
     */
    public int getNbAntiRollBarData() {
        return _getNbAntiRollBarData(address);
    }
    private static native int _getNbAntiRollBarData(long address);

    /**
     * @param id       unsigned long
     * @param antiRoll {@link PxVehicleAntiRollBarData} [Const, Ref]
     */
    public void setAntiRollBarData(int id, PxVehicleAntiRollBarData antiRoll) {
        _setAntiRollBarData(address, id, antiRoll.getAddress());
    }
    private static native void _setAntiRollBarData(long address, int id, long antiRoll);

}
