package physx.vehicle;

import physx.NativeObject;

public class PxVehicleWheelsDynData extends NativeObject {

    protected PxVehicleWheelsDynData() { }

    public static PxVehicleWheelsDynData wrapPointer(long address) {
        return new PxVehicleWheelsDynData(address);
    }
    
    protected PxVehicleWheelsDynData(long address) {
        super(address);
    }

    // Destructor

    public void destroy() {
        if (address == 0L) {
            throw new IllegalStateException(this + " is already deleted");
        }
        if (isStackAllocated) {
            throw new IllegalStateException(this + " is stack allocated and cannot be deleted");
        }
        _delete_native_instance(address);
        address = 0L;
    }
    private static native long _delete_native_instance(long address);

    // Functions

    public void setToRestState() {
        _setToRestState(address);
    }
    private static native void _setToRestState(long address);

    /**
     * @param wheelIdx unsigned long
     * @param speed    float
     */
    public void setWheelRotationSpeed(int wheelIdx, float speed) {
        _setWheelRotationSpeed(address, wheelIdx, speed);
    }
    private static native void _setWheelRotationSpeed(long address, int wheelIdx, float speed);

    /**
     * @param wheelIdx unsigned long
     * @return float
     */
    public float getWheelRotationSpeed(int wheelIdx) {
        return _getWheelRotationSpeed(address, wheelIdx);
    }
    private static native float _getWheelRotationSpeed(long address, int wheelIdx);

    /**
     * @param wheelIdx unsigned long
     * @param angle    float
     */
    public void setWheelRotationAngle(int wheelIdx, float angle) {
        _setWheelRotationAngle(address, wheelIdx, angle);
    }
    private static native void _setWheelRotationAngle(long address, int wheelIdx, float angle);

    /**
     * @param wheelIdx unsigned long
     * @return float
     */
    public float getWheelRotationAngle(int wheelIdx) {
        return _getWheelRotationAngle(address, wheelIdx);
    }
    private static native float _getWheelRotationAngle(long address, int wheelIdx);

    /**
     * @param src      {@link PxVehicleWheelsDynData} [Const, Ref]
     * @param srcWheel unsigned long
     * @param trgWheel unsigned long
     */
    public void copy(PxVehicleWheelsDynData src, int srcWheel, int trgWheel) {
        _copy(address, src.getAddress(), srcWheel, trgWheel);
    }
    private static native void _copy(long address, long src, int srcWheel, int trgWheel);

    /**
     * @return unsigned long
     */
    public int getNbWheelRotationSpeed() {
        return _getNbWheelRotationSpeed(address);
    }
    private static native int _getNbWheelRotationSpeed(long address);

    /**
     * @return unsigned long
     */
    public int getNbWheelRotationAngle() {
        return _getNbWheelRotationAngle(address);
    }
    private static native int _getNbWheelRotationAngle(long address);

}
