package physx.vehicle;

import physx.common.PxBase;
import physx.physics.PxRigidDynamic;

public class PxVehicleWheels extends PxBase {

    protected PxVehicleWheels() { }

    public static PxVehicleWheels wrapPointer(long address) {
        return new PxVehicleWheels(address);
    }
    
    protected PxVehicleWheels(long address) {
        super(address);
    }

    // Attributes

    /**
     * @return {@link PxVehicleWheelsSimData} [Value]
     */
    public PxVehicleWheelsSimData getMWheelsSimData() {
        return PxVehicleWheelsSimData.wrapPointer(_getMWheelsSimData(address));
    }
    private static native long _getMWheelsSimData(long address);

    /**
     * @param value {@link PxVehicleWheelsSimData} [Value]
     */
    public void setMWheelsSimData(PxVehicleWheelsSimData value) {
        _setMWheelsSimData(address, value.getAddress());
    }
    private static native void _setMWheelsSimData(long address, long value);

    /**
     * @return {@link PxVehicleWheelsDynData} [Value]
     */
    public PxVehicleWheelsDynData getMWheelsDynData() {
        return PxVehicleWheelsDynData.wrapPointer(_getMWheelsDynData(address));
    }
    private static native long _getMWheelsDynData(long address);

    /**
     * @param value {@link PxVehicleWheelsDynData} [Value]
     */
    public void setMWheelsDynData(PxVehicleWheelsDynData value) {
        _setMWheelsDynData(address, value.getAddress());
    }
    private static native void _setMWheelsDynData(long address, long value);

    // Functions

    /**
     * @return unsigned long
     */
    public int getVehicleType() {
        return _getVehicleType(address);
    }
    private static native int _getVehicleType(long address);

    /**
     * @return {@link PxRigidDynamic}
     */
    public PxRigidDynamic getRigidDynamicActor() {
        return PxRigidDynamic.wrapPointer(_getRigidDynamicActor(address));
    }
    private static native long _getRigidDynamicActor(long address);

    /**
     * @return float
     */
    public float computeForwardSpeed() {
        return _computeForwardSpeed(address);
    }
    private static native float _computeForwardSpeed(long address);

    /**
     * @return float
     */
    public float computeSidewaysSpeed() {
        return _computeSidewaysSpeed(address);
    }
    private static native float _computeSidewaysSpeed(long address);

    /**
     * @return unsigned long
     */
    public int getNbNonDrivenWheels() {
        return _getNbNonDrivenWheels(address);
    }
    private static native int _getNbNonDrivenWheels(long address);

}
