package physx.vehicle;

import physx.NativeObject;
import physx.common.PxRealPtr;
import physx.common.PxVec3;
import physx.physics.PxBatchQuery;
import physx.physics.PxPhysics;
import physx.physics.PxRaycastQueryResult;
import physx.support.Vector_PxVehicleWheels;

public class PxVehicleTopLevelFunctions extends NativeObject {

    protected PxVehicleTopLevelFunctions() { }

    public static PxVehicleTopLevelFunctions wrapPointer(long address) {
        return new PxVehicleTopLevelFunctions(address);
    }
    
    protected PxVehicleTopLevelFunctions(long address) {
        super(address);
    }

    // Destructor

    public void destroy() {
        if (address == 0L) {
            throw new IllegalStateException(this + " is already deleted");
        }
        if (isStackAllocated) {
            throw new IllegalStateException(this + " is stack allocated and cannot be deleted");
        }
        _delete_native_instance(address);
        address = 0L;
    }
    private static native long _delete_native_instance(long address);

    // Functions

    /**
     * @param physics {@link PxPhysics} [Ref]
     * @return boolean
     */
    public static boolean InitVehicleSDK(PxPhysics physics) {
        return _InitVehicleSDK(physics.getAddress());
    }
    private static native boolean _InitVehicleSDK(long physics);

    /**
     * @param nbSprungMasses        unsigned long
     * @param sprungMassCoordinates {@link PxVec3} [Const]
     * @param centreOfMass          {@link PxVec3} [Const, Ref]
     * @param totalMass             float
     * @param gravityDirection      unsigned long
     * @param sprungMasses          {@link PxRealPtr} [Ref]
     */
    public static void PxVehicleComputeSprungMasses(int nbSprungMasses, PxVec3 sprungMassCoordinates, PxVec3 centreOfMass, float totalMass, int gravityDirection, PxRealPtr sprungMasses) {
        _PxVehicleComputeSprungMasses(nbSprungMasses, sprungMassCoordinates.getAddress(), centreOfMass.getAddress(), totalMass, gravityDirection, sprungMasses.getAddress());
    }
    private static native void _PxVehicleComputeSprungMasses(int nbSprungMasses, long sprungMassCoordinates, long centreOfMass, float totalMass, int gravityDirection, long sprungMasses);

    /**
     * @param batchQuery          {@link PxBatchQuery}
     * @param vehicles            {@link Vector_PxVehicleWheels} [Ref]
     * @param nbSceneQueryResults unsigned long
     * @param sceneQueryResults   {@link PxRaycastQueryResult}
     */
    public static void PxVehicleSuspensionRaycasts(PxBatchQuery batchQuery, Vector_PxVehicleWheels vehicles, int nbSceneQueryResults, PxRaycastQueryResult sceneQueryResults) {
        _PxVehicleSuspensionRaycasts(batchQuery.getAddress(), vehicles.getAddress(), nbSceneQueryResults, sceneQueryResults.getAddress());
    }
    private static native void _PxVehicleSuspensionRaycasts(long batchQuery, long vehicles, int nbSceneQueryResults, long sceneQueryResults);

    /**
     * @param timestep                                  float
     * @param gravity                                   {@link PxVec3} [Const, Ref]
     * @param vehicleDrivableSurfaceToTireFrictionPairs {@link PxVehicleDrivableSurfaceToTireFrictionPairs} [Const, Ref]
     * @param vehicles                                  {@link Vector_PxVehicleWheels} [Ref]
     * @param vehicleWheelQueryResults                  {@link PxVehicleWheelQueryResult}
     */
    public static void PxVehicleUpdates(float timestep, PxVec3 gravity, PxVehicleDrivableSurfaceToTireFrictionPairs vehicleDrivableSurfaceToTireFrictionPairs, Vector_PxVehicleWheels vehicles, PxVehicleWheelQueryResult vehicleWheelQueryResults) {
        _PxVehicleUpdates(timestep, gravity.getAddress(), vehicleDrivableSurfaceToTireFrictionPairs.getAddress(), vehicles.getAddress(), vehicleWheelQueryResults.getAddress());
    }
    private static native void _PxVehicleUpdates(float timestep, long gravity, long vehicleDrivableSurfaceToTireFrictionPairs, long vehicles, long vehicleWheelQueryResults);

    /**
     * @param up      {@link PxVec3} [Const, Ref]
     * @param forward {@link PxVec3} [Const, Ref]
     */
    public static void VehicleSetBasisVectors(PxVec3 up, PxVec3 forward) {
        _VehicleSetBasisVectors(up.getAddress(), forward.getAddress());
    }
    private static native void _VehicleSetBasisVectors(long up, long forward);

    /**
     * @param vehicleUpdateMode {@link PxVehicleUpdateModeEnum} [enum]
     */
    public static void VehicleSetUpdateMode(int vehicleUpdateMode) {
        _VehicleSetUpdateMode(vehicleUpdateMode);
    }
    private static native void _VehicleSetUpdateMode(int vehicleUpdateMode);

    /**
     * @param tireData {@link PxVehicleTireData}
     * @param m        unsigned long
     * @param n        unsigned long
     * @return float
     */
    public static float PxVehicleTireData_getFrictionVsSlipGraph(PxVehicleTireData tireData, int m, int n) {
        return _PxVehicleTireData_getFrictionVsSlipGraph(tireData.getAddress(), m, n);
    }
    private static native float _PxVehicleTireData_getFrictionVsSlipGraph(long tireData, int m, int n);

    /**
     * @param tireData {@link PxVehicleTireData}
     * @param m        unsigned long
     * @param n        unsigned long
     * @param value    float
     */
    public static void PxVehicleTireData_setFrictionVsSlipGraph(PxVehicleTireData tireData, int m, int n, float value) {
        _PxVehicleTireData_setFrictionVsSlipGraph(tireData.getAddress(), m, n, value);
    }
    private static native void _PxVehicleTireData_setFrictionVsSlipGraph(long tireData, int m, int n, float value);

}
