package physx.vehicle;

import physx.NativeObject;

public class PxVehicleTireData extends NativeObject {

    public static PxVehicleTireData wrapPointer(long address) {
        return new PxVehicleTireData(address);
    }
    
    protected PxVehicleTireData(long address) {
        super(address);
    }

    // Constructors

    public PxVehicleTireData() {
        address = _PxVehicleTireData();
    }
    private static native long _PxVehicleTireData();

    // Destructor

    public void destroy() {
        if (address == 0L) {
            throw new IllegalStateException(this + " is already deleted");
        }
        if (isStackAllocated) {
            throw new IllegalStateException(this + " is stack allocated and cannot be deleted");
        }
        _delete_native_instance(address);
        address = 0L;
    }
    private static native long _delete_native_instance(long address);

    // Attributes

    /**
     * @return float
     */
    public float getMLatStiffX() {
        return _getMLatStiffX(address);
    }
    private static native float _getMLatStiffX(long address);

    /**
     * @param value float
     */
    public void setMLatStiffX(float value) {
        _setMLatStiffX(address, value);
    }
    private static native void _setMLatStiffX(long address, float value);

    /**
     * @return float
     */
    public float getMLatStiffY() {
        return _getMLatStiffY(address);
    }
    private static native float _getMLatStiffY(long address);

    /**
     * @param value float
     */
    public void setMLatStiffY(float value) {
        _setMLatStiffY(address, value);
    }
    private static native void _setMLatStiffY(long address, float value);

    /**
     * @return float
     */
    public float getMLongitudinalStiffnessPerUnitGravity() {
        return _getMLongitudinalStiffnessPerUnitGravity(address);
    }
    private static native float _getMLongitudinalStiffnessPerUnitGravity(long address);

    /**
     * @param value float
     */
    public void setMLongitudinalStiffnessPerUnitGravity(float value) {
        _setMLongitudinalStiffnessPerUnitGravity(address, value);
    }
    private static native void _setMLongitudinalStiffnessPerUnitGravity(long address, float value);

    /**
     * @return float
     */
    public float getMCamberStiffnessPerUnitGravity() {
        return _getMCamberStiffnessPerUnitGravity(address);
    }
    private static native float _getMCamberStiffnessPerUnitGravity(long address);

    /**
     * @param value float
     */
    public void setMCamberStiffnessPerUnitGravity(float value) {
        _setMCamberStiffnessPerUnitGravity(address, value);
    }
    private static native void _setMCamberStiffnessPerUnitGravity(long address, float value);

    /**
     * @return unsigned long
     */
    public int getMType() {
        return _getMType(address);
    }
    private static native int _getMType(long address);

    /**
     * @param value unsigned long
     */
    public void setMType(int value) {
        _setMType(address, value);
    }
    private static native void _setMType(long address, int value);

}
