package physx.vehicle;

import physx.NativeObject;

public class PxVehicleEngineData extends NativeObject {

    public static PxVehicleEngineData wrapPointer(long address) {
        return new PxVehicleEngineData(address);
    }
    
    protected PxVehicleEngineData(long address) {
        super(address);
    }

    // Constructors

    public PxVehicleEngineData() {
        address = _PxVehicleEngineData();
    }
    private static native long _PxVehicleEngineData();

    // Destructor

    public void destroy() {
        if (address == 0L) {
            throw new IllegalStateException(this + " is already deleted");
        }
        if (isStackAllocated) {
            throw new IllegalStateException(this + " is stack allocated and cannot be deleted");
        }
        _delete_native_instance(address);
        address = 0L;
    }
    private static native long _delete_native_instance(long address);

    // Attributes

    /**
     * @return {@link PxEngineTorqueLookupTable} [Value]
     */
    public PxEngineTorqueLookupTable getMTorqueCurve() {
        return PxEngineTorqueLookupTable.wrapPointer(_getMTorqueCurve(address));
    }
    private static native long _getMTorqueCurve(long address);

    /**
     * @param value {@link PxEngineTorqueLookupTable} [Value]
     */
    public void setMTorqueCurve(PxEngineTorqueLookupTable value) {
        _setMTorqueCurve(address, value.getAddress());
    }
    private static native void _setMTorqueCurve(long address, long value);

    /**
     * @return float
     */
    public float getMMOI() {
        return _getMMOI(address);
    }
    private static native float _getMMOI(long address);

    /**
     * @param value float
     */
    public void setMMOI(float value) {
        _setMMOI(address, value);
    }
    private static native void _setMMOI(long address, float value);

    /**
     * @return float
     */
    public float getMPeakTorque() {
        return _getMPeakTorque(address);
    }
    private static native float _getMPeakTorque(long address);

    /**
     * @param value float
     */
    public void setMPeakTorque(float value) {
        _setMPeakTorque(address, value);
    }
    private static native void _setMPeakTorque(long address, float value);

    /**
     * @return float
     */
    public float getMMaxOmega() {
        return _getMMaxOmega(address);
    }
    private static native float _getMMaxOmega(long address);

    /**
     * @param value float
     */
    public void setMMaxOmega(float value) {
        _setMMaxOmega(address, value);
    }
    private static native void _setMMaxOmega(long address, float value);

    /**
     * @return float
     */
    public float getMDampingRateFullThrottle() {
        return _getMDampingRateFullThrottle(address);
    }
    private static native float _getMDampingRateFullThrottle(long address);

    /**
     * @param value float
     */
    public void setMDampingRateFullThrottle(float value) {
        _setMDampingRateFullThrottle(address, value);
    }
    private static native void _setMDampingRateFullThrottle(long address, float value);

    /**
     * @return float
     */
    public float getMDampingRateZeroThrottleClutchEngaged() {
        return _getMDampingRateZeroThrottleClutchEngaged(address);
    }
    private static native float _getMDampingRateZeroThrottleClutchEngaged(long address);

    /**
     * @param value float
     */
    public void setMDampingRateZeroThrottleClutchEngaged(float value) {
        _setMDampingRateZeroThrottleClutchEngaged(address, value);
    }
    private static native void _setMDampingRateZeroThrottleClutchEngaged(long address, float value);

    /**
     * @return float
     */
    public float getMDampingRateZeroThrottleClutchDisengaged() {
        return _getMDampingRateZeroThrottleClutchDisengaged(address);
    }
    private static native float _getMDampingRateZeroThrottleClutchDisengaged(long address);

    /**
     * @param value float
     */
    public void setMDampingRateZeroThrottleClutchDisengaged(float value) {
        _setMDampingRateZeroThrottleClutchDisengaged(address, value);
    }
    private static native void _setMDampingRateZeroThrottleClutchDisengaged(long address, float value);

}
