package physx.vehicle;

import physx.physics.PxPhysics;
import physx.physics.PxRigidDynamic;

public class PxVehicleDrive4W extends PxVehicleDrive {

    protected PxVehicleDrive4W() { }

    public static PxVehicleDrive4W wrapPointer(long address) {
        return new PxVehicleDrive4W(address);
    }
    
    protected PxVehicleDrive4W(long address) {
        super(address);
    }

    // Attributes

    /**
     * @return {@link PxVehicleDriveSimData4W} [Value]
     */
    public PxVehicleDriveSimData4W getMDriveSimData() {
        return PxVehicleDriveSimData4W.wrapPointer(_getMDriveSimData(address));
    }
    private static native long _getMDriveSimData(long address);

    /**
     * @param value {@link PxVehicleDriveSimData4W} [Value]
     */
    public void setMDriveSimData(PxVehicleDriveSimData4W value) {
        _setMDriveSimData(address, value.getAddress());
    }
    private static native void _setMDriveSimData(long address, long value);

    // Functions

    /**
     * @param nbWheels unsigned long
     * @return {@link PxVehicleDrive4W}
     */
    public static PxVehicleDrive4W allocate(int nbWheels) {
        return PxVehicleDrive4W.wrapPointer(_allocate(nbWheels));
    }
    private static native long _allocate(int nbWheels);

    public void free() {
        _free(address);
    }
    private static native void _free(long address);

    /**
     * @param physics           {@link PxPhysics}
     * @param vehActor          {@link PxRigidDynamic}
     * @param wheelsData        {@link PxVehicleWheelsSimData} [Const, Ref]
     * @param driveData         {@link PxVehicleDriveSimData4W} [Const, Ref]
     * @param nbNonDrivenWheels unsigned long
     */
    public void setup(PxPhysics physics, PxRigidDynamic vehActor, PxVehicleWheelsSimData wheelsData, PxVehicleDriveSimData4W driveData, int nbNonDrivenWheels) {
        _setup(address, physics.getAddress(), vehActor.getAddress(), wheelsData.getAddress(), driveData.getAddress(), nbNonDrivenWheels);
    }
    private static native void _setup(long address, long physics, long vehActor, long wheelsData, long driveData, int nbNonDrivenWheels);

    public void setToRestState() {
        _setToRestState(address);
    }
    private static native void _setToRestState(long address);

}
