package physx.vehicle;

import physx.NativeObject;

public class PxVehicleDrivableSurfaceType extends NativeObject {

    public static PxVehicleDrivableSurfaceType wrapPointer(long address) {
        return new PxVehicleDrivableSurfaceType(address);
    }
    
    protected PxVehicleDrivableSurfaceType(long address) {
        super(address);
    }

    // Constructors

    public PxVehicleDrivableSurfaceType() {
        address = _PxVehicleDrivableSurfaceType();
    }
    private static native long _PxVehicleDrivableSurfaceType();

    // Destructor

    public void destroy() {
        if (address == 0L) {
            throw new IllegalStateException(this + " is already deleted");
        }
        if (isStackAllocated) {
            throw new IllegalStateException(this + " is stack allocated and cannot be deleted");
        }
        _delete_native_instance(address);
        address = 0L;
    }
    private static native long _delete_native_instance(long address);

    // Attributes

    /**
     * @return unsigned long
     */
    public int getMType() {
        return _getMType(address);
    }
    private static native int _getMType(long address);

    /**
     * @param value unsigned long
     */
    public void setMType(int value) {
        _setMType(address, value);
    }
    private static native void _setMType(long address, int value);

}
