package physx.vehicle;

import physx.NativeObject;
import physx.support.PxMaterialPtr;

public class PxVehicleDrivableSurfaceToTireFrictionPairs extends NativeObject {

    protected PxVehicleDrivableSurfaceToTireFrictionPairs() { }

    public static PxVehicleDrivableSurfaceToTireFrictionPairs wrapPointer(long address) {
        return new PxVehicleDrivableSurfaceToTireFrictionPairs(address);
    }
    
    protected PxVehicleDrivableSurfaceToTireFrictionPairs(long address) {
        super(address);
    }

    // Functions

    /**
     * @param maxNbTireTypes    unsigned long
     * @param maxNbSurfaceTypes unsigned long
     * @return {@link PxVehicleDrivableSurfaceToTireFrictionPairs}
     */
    public static PxVehicleDrivableSurfaceToTireFrictionPairs allocate(int maxNbTireTypes, int maxNbSurfaceTypes) {
        return PxVehicleDrivableSurfaceToTireFrictionPairs.wrapPointer(_allocate(maxNbTireTypes, maxNbSurfaceTypes));
    }
    private static native long _allocate(int maxNbTireTypes, int maxNbSurfaceTypes);

    /**
     * @param nbTireTypes              unsigned long
     * @param nbSurfaceTypes           unsigned long
     * @param drivableSurfaceMaterials {@link PxMaterialPtr}
     * @param drivableSurfaceTypes     {@link PxVehicleDrivableSurfaceType} [Const]
     */
    public void setup(int nbTireTypes, int nbSurfaceTypes, PxMaterialPtr drivableSurfaceMaterials, PxVehicleDrivableSurfaceType drivableSurfaceTypes) {
        _setup(address, nbTireTypes, nbSurfaceTypes, drivableSurfaceMaterials.getAddress(), drivableSurfaceTypes.getAddress());
    }
    private static native void _setup(long address, int nbTireTypes, int nbSurfaceTypes, long drivableSurfaceMaterials, long drivableSurfaceTypes);

    public void release() {
        _release(address);
    }
    private static native void _release(long address);

    /**
     * @param surfaceType unsigned long
     * @param tireType    unsigned long
     * @param value       float
     */
    public void setTypePairFriction(int surfaceType, int tireType, float value) {
        _setTypePairFriction(address, surfaceType, tireType, value);
    }
    private static native void _setTypePairFriction(long address, int surfaceType, int tireType, float value);

    /**
     * @param surfaceType unsigned long
     * @param tireType    unsigned long
     * @return float
     */
    public float getTypePairFriction(int surfaceType, int tireType) {
        return _getTypePairFriction(address, surfaceType, tireType);
    }
    private static native float _getTypePairFriction(long address, int surfaceType, int tireType);

    /**
     * @return unsigned long
     */
    public int getMaxNbSurfaceTypes() {
        return _getMaxNbSurfaceTypes(address);
    }
    private static native int _getMaxNbSurfaceTypes(long address);

    /**
     * @return unsigned long
     */
    public int getMaxNbTireTypes() {
        return _getMaxNbTireTypes(address);
    }
    private static native int _getMaxNbTireTypes(long address);

}
