package physx.support;

import physx.NativeObject;
import physx.vehicle.PxWheelQueryResult;

public class Vector_PxWheelQueryResult extends NativeObject {

    public static Vector_PxWheelQueryResult wrapPointer(long address) {
        return new Vector_PxWheelQueryResult(address);
    }
    
    protected Vector_PxWheelQueryResult(long address) {
        super(address);
    }

    // Constructors

    public Vector_PxWheelQueryResult() {
        address = _Vector_PxWheelQueryResult();
    }
    private static native long _Vector_PxWheelQueryResult();

    /**
     * @param size unsigned long
     */
    public Vector_PxWheelQueryResult(int size) {
        address = _Vector_PxWheelQueryResult(size);
    }
    private static native long _Vector_PxWheelQueryResult(int size);

    // Destructor

    public void destroy() {
        if (address == 0L) {
            throw new IllegalStateException(this + " is already deleted");
        }
        if (isStackAllocated) {
            throw new IllegalStateException(this + " is stack allocated and cannot be deleted");
        }
        _delete_native_instance(address);
        address = 0L;
    }
    private static native long _delete_native_instance(long address);

    // Functions

    /**
     * @param index unsigned long
     * @return {@link PxWheelQueryResult} [Ref]
     */
    public PxWheelQueryResult at(int index) {
        return PxWheelQueryResult.wrapPointer(_at(address, index));
    }
    private static native long _at(long address, int index);

    /**
     * @return {@link PxWheelQueryResult}
     */
    public PxWheelQueryResult data() {
        return PxWheelQueryResult.wrapPointer(_data(address));
    }
    private static native long _data(long address);

    /**
     * @return unsigned long
     */
    public int size() {
        return _size(address);
    }
    private static native int _size(long address);

    /**
     * @param value {@link PxWheelQueryResult} [Ref]
     */
    public void push_back(PxWheelQueryResult value) {
        _push_back(address, value.getAddress());
    }
    private static native void _push_back(long address, long value);

}
