package physx.support;

import physx.NativeObject;
import physx.physics.PxRaycastHit;

public class Vector_PxRaycastHit extends NativeObject {

    public static Vector_PxRaycastHit wrapPointer(long address) {
        return new Vector_PxRaycastHit(address);
    }
    
    protected Vector_PxRaycastHit(long address) {
        super(address);
    }

    // Constructors

    public Vector_PxRaycastHit() {
        address = _Vector_PxRaycastHit();
    }
    private static native long _Vector_PxRaycastHit();

    /**
     * @param size unsigned long
     */
    public Vector_PxRaycastHit(int size) {
        address = _Vector_PxRaycastHit(size);
    }
    private static native long _Vector_PxRaycastHit(int size);

    // Destructor

    public void destroy() {
        if (address == 0L) {
            throw new IllegalStateException(this + " is already deleted");
        }
        if (isStackAllocated) {
            throw new IllegalStateException(this + " is stack allocated and cannot be deleted");
        }
        _delete_native_instance(address);
        address = 0L;
    }
    private static native long _delete_native_instance(long address);

    // Functions

    /**
     * @param index unsigned long
     * @return {@link PxRaycastHit} [Ref]
     */
    public PxRaycastHit at(int index) {
        return PxRaycastHit.wrapPointer(_at(address, index));
    }
    private static native long _at(long address, int index);

    /**
     * @return {@link PxRaycastHit}
     */
    public PxRaycastHit data() {
        return PxRaycastHit.wrapPointer(_data(address));
    }
    private static native long _data(long address);

    /**
     * @return unsigned long
     */
    public int size() {
        return _size(address);
    }
    private static native int _size(long address);

    /**
     * @param value {@link PxRaycastHit} [Ref]
     */
    public void push_back(PxRaycastHit value) {
        _push_back(address, value.getAddress());
    }
    private static native void _push_back(long address, long value);

}
