package physx.physics;

import physx.NativeObject;
import physx.common.PxCpuDispatcher;
import physx.common.PxTolerancesScale;
import physx.common.PxVec3;

public class PxSceneDesc extends NativeObject {

    protected PxSceneDesc() { }

    public static PxSceneDesc wrapPointer(long address) {
        return new PxSceneDesc(address);
    }
    
    protected PxSceneDesc(long address) {
        super(address);
    }

    // Constructors

    /**
     * @param scale {@link PxTolerancesScale} [Const, Ref]
     */
    public PxSceneDesc(PxTolerancesScale scale) {
        address = _PxSceneDesc(scale.getAddress());
    }
    private static native long _PxSceneDesc(long scale);

    // Destructor

    public void destroy() {
        if (address == 0L) {
            throw new IllegalStateException(this + " is already deleted");
        }
        if (isStackAllocated) {
            throw new IllegalStateException(this + " is stack allocated and cannot be deleted");
        }
        _delete_native_instance(address);
        address = 0L;
    }
    private static native long _delete_native_instance(long address);

    // Attributes

    /**
     * @return {@link PxVec3} [Value]
     */
    public PxVec3 getGravity() {
        return PxVec3.wrapPointer(_getGravity(address));
    }
    private static native long _getGravity(long address);

    /**
     * @param value {@link PxVec3} [Value]
     */
    public void setGravity(PxVec3 value) {
        _setGravity(address, value.getAddress());
    }
    private static native void _setGravity(long address, long value);

    /**
     * @return {@link PxSimulationEventCallback}
     */
    public PxSimulationEventCallback getSimulationEventCallback() {
        return PxSimulationEventCallback.wrapPointer(_getSimulationEventCallback(address));
    }
    private static native long _getSimulationEventCallback(long address);

    /**
     * @param value {@link PxSimulationEventCallback}
     */
    public void setSimulationEventCallback(PxSimulationEventCallback value) {
        _setSimulationEventCallback(address, value.getAddress());
    }
    private static native void _setSimulationEventCallback(long address, long value);

    /**
     * @return {@link PxSimulationFilterShader} [Value]
     */
    public PxSimulationFilterShader getFilterShader() {
        return PxSimulationFilterShader.wrapPointer(_getFilterShader(address));
    }
    private static native long _getFilterShader(long address);

    /**
     * @param value {@link PxSimulationFilterShader} [Value]
     */
    public void setFilterShader(PxSimulationFilterShader value) {
        _setFilterShader(address, value.getAddress());
    }
    private static native void _setFilterShader(long address, long value);

    /**
     * @return {@link PxCpuDispatcher}
     */
    public PxCpuDispatcher getCpuDispatcher() {
        return PxCpuDispatcher.wrapPointer(_getCpuDispatcher(address));
    }
    private static native long _getCpuDispatcher(long address);

    /**
     * @param value {@link PxCpuDispatcher}
     */
    public void setCpuDispatcher(PxCpuDispatcher value) {
        _setCpuDispatcher(address, value.getAddress());
    }
    private static native void _setCpuDispatcher(long address, long value);

    /**
     * @return {@link PxSceneFlags} [Value]
     */
    public PxSceneFlags getFlags() {
        return PxSceneFlags.wrapPointer(_getFlags(address));
    }
    private static native long _getFlags(long address);

    /**
     * @param value {@link PxSceneFlags} [Value]
     */
    public void setFlags(PxSceneFlags value) {
        _setFlags(address, value.getAddress());
    }
    private static native void _setFlags(long address, long value);

}
