package physx.physics;

import physx.common.PxTransform;

public class PxRigidActor extends PxActor {

    protected PxRigidActor() { }

    public static PxRigidActor wrapPointer(long address) {
        return new PxRigidActor(address);
    }
    
    protected PxRigidActor(long address) {
        super(address);
    }

    // Functions

    /**
     * @return {@link PxTransform} [Value]
     */
    public PxTransform getGlobalPose() {
        return PxTransform.wrapPointer(_getGlobalPose(address));
    }
    private static native long _getGlobalPose(long address);

    /**
     * @param pose {@link PxTransform} [Const, Ref]
     */
    public void setGlobalPose(PxTransform pose) {
        _setGlobalPose(address, pose.getAddress());
    }
    private static native void _setGlobalPose(long address, long pose);

    /**
     * @param pose     {@link PxTransform} [Const, Ref]
     * @param autowake boolean
     */
    public void setGlobalPose(PxTransform pose, boolean autowake) {
        _setGlobalPose(address, pose.getAddress(), autowake);
    }
    private static native void _setGlobalPose(long address, long pose, boolean autowake);

    /**
     * @param shape {@link PxShape} [Ref]
     * @return boolean
     */
    public boolean attachShape(PxShape shape) {
        return _attachShape(address, shape.getAddress());
    }
    private static native boolean _attachShape(long address, long shape);

    /**
     * @param shape {@link PxShape} [Ref]
     */
    public void detachShape(PxShape shape) {
        _detachShape(address, shape.getAddress());
    }
    private static native void _detachShape(long address, long shape);

    /**
     * @param shape           {@link PxShape} [Ref]
     * @param wakeOnLostTouch boolean
     */
    public void detachShape(PxShape shape, boolean wakeOnLostTouch) {
        _detachShape(address, shape.getAddress(), wakeOnLostTouch);
    }
    private static native void _detachShape(long address, long shape, boolean wakeOnLostTouch);

    /**
     * @return long
     */
    public int getNbShapes() {
        return _getNbShapes(address);
    }
    private static native int _getNbShapes(long address);

}
