package physx.physics;


public class PxRaycastHit extends PxLocationHit {

    public static PxRaycastHit wrapPointer(long address) {
        return new PxRaycastHit(address);
    }
    
    protected PxRaycastHit(long address) {
        super(address);
    }

    // Constructors

    public PxRaycastHit() {
        address = _PxRaycastHit();
    }
    private static native long _PxRaycastHit();

    // Destructor

    public void destroy() {
        if (address == 0L) {
            throw new IllegalStateException(this + " is already deleted");
        }
        if (isStackAllocated) {
            throw new IllegalStateException(this + " is stack allocated and cannot be deleted");
        }
        _delete_native_instance(address);
        address = 0L;
    }
    private static native long _delete_native_instance(long address);

    // Attributes

    /**
     * @return float
     */
    public float getU() {
        return _getU(address);
    }
    private static native float _getU(long address);

    /**
     * @param value float
     */
    public void setU(float value) {
        _setU(address, value);
    }
    private static native void _setU(long address, float value);

    /**
     * @return float
     */
    public float getV() {
        return _getV(address);
    }
    private static native float _getV(long address);

    /**
     * @param value float
     */
    public void setV(float value) {
        _setV(address, value);
    }
    private static native void _setV(long address, float value);

}
