package physx.physics;

import physx.common.PxVec3;

public class PxLocationHit extends PxQueryHit {

    protected PxLocationHit() { }

    public static PxLocationHit wrapPointer(long address) {
        return new PxLocationHit(address);
    }
    
    protected PxLocationHit(long address) {
        super(address);
    }

    // Destructor

    public void destroy() {
        if (address == 0L) {
            throw new IllegalStateException(this + " is already deleted");
        }
        if (isStackAllocated) {
            throw new IllegalStateException(this + " is stack allocated and cannot be deleted");
        }
        _delete_native_instance(address);
        address = 0L;
    }
    private static native long _delete_native_instance(long address);

    // Attributes

    /**
     * @return {@link PxHitFlags} [Value]
     */
    public PxHitFlags getFlags() {
        return PxHitFlags.wrapPointer(_getFlags(address));
    }
    private static native long _getFlags(long address);

    /**
     * @param value {@link PxHitFlags} [Value]
     */
    public void setFlags(PxHitFlags value) {
        _setFlags(address, value.getAddress());
    }
    private static native void _setFlags(long address, long value);

    /**
     * @return {@link PxVec3} [Value]
     */
    public PxVec3 getPosition() {
        return PxVec3.wrapPointer(_getPosition(address));
    }
    private static native long _getPosition(long address);

    /**
     * @param value {@link PxVec3} [Value]
     */
    public void setPosition(PxVec3 value) {
        _setPosition(address, value.getAddress());
    }
    private static native void _setPosition(long address, long value);

    /**
     * @return {@link PxVec3} [Value]
     */
    public PxVec3 getNormal() {
        return PxVec3.wrapPointer(_getNormal(address));
    }
    private static native long _getNormal(long address);

    /**
     * @param value {@link PxVec3} [Value]
     */
    public void setNormal(PxVec3 value) {
        _setNormal(address, value.getAddress());
    }
    private static native void _setNormal(long address, long value);

    /**
     * @return float
     */
    public float getDistance() {
        return _getDistance(address);
    }
    private static native float _getDistance(long address);

    /**
     * @param value float
     */
    public void setDistance(float value) {
        _setDistance(address, value);
    }
    private static native void _setDistance(long address, float value);

}
